/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.config;

import jodd.madvoc.config.ActionRuntime;
import jodd.madvoc.config.Routes;
import jodd.madvoc.macro.PathMacros;
import jodd.util.ArraysUtil;

public class RouteChunk {
    private final String value;
    private RouteChunk[] children;
    private final PathMacros pathMacros;
    private final Routes routes;
    private final RouteChunk parent;
    private final boolean hasMacros;
    private ActionRuntime actionRuntime;

    protected RouteChunk(Routes routes, RouteChunk parent, String value) {
        this.routes = routes;
        this.parent = parent;
        this.value = value;
        this.pathMacros = routes.buildActionPathMacros(value);
        this.hasMacros = this.pathMacros != null ? true : parent != null && parent.hasMacros;
    }

    public RouteChunk add(String newValue) {
        RouteChunk routeChunk = new RouteChunk(this.routes, this, newValue);
        this.children = this.children == null ? new RouteChunk[]{routeChunk} : ArraysUtil.append(this.children, routeChunk);
        return routeChunk;
    }

    public RouteChunk findOrCreateChild(String value) {
        if (this.children != null) {
            for (RouteChunk child : this.children) {
                if (!child.get().equals(value)) continue;
                return child;
            }
        }
        return this.add(value);
    }

    public void bind(ActionRuntime actionRuntime) {
        this.actionRuntime = actionRuntime;
        this.actionRuntime.bind(this);
    }

    public boolean isEndpoint() {
        return this.actionRuntime != null;
    }

    public ActionRuntime value() {
        return this.actionRuntime;
    }

    public String get() {
        return this.value;
    }

    public RouteChunk parent() {
        return this.parent;
    }

    public PathMacros pathMacros() {
        return this.pathMacros;
    }

    public boolean hasMacrosOnPath() {
        return this.hasMacros;
    }

    public RouteChunk[] children() {
        return this.children;
    }

    public boolean match(String value) {
        if (this.pathMacros == null) {
            return this.value.equals(value);
        }
        return this.pathMacros.match(value) != -1;
    }

    public String toString() {
        return "RouteChunk{value='" + this.value + '\'' + '}';
    }
}

