/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.component;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import jodd.madvoc.MadvocException;
import jodd.madvoc.scope.MadvocScope;
import jodd.madvoc.scope.RequestScope;
import jodd.petite.PetiteContainer;
import jodd.petite.meta.PetiteInject;

public class ScopeResolver {
    @PetiteInject
    protected PetiteContainer madpc;
    protected List<MadvocScope> allScopes = new ArrayList<MadvocScope>();

    public <S extends MadvocScope> S defaultOrScopeType(Class<S> scopeClass) {
        if (scopeClass == null) {
            return (S)this.getOrInitScope(RequestScope.class);
        }
        return (S)this.getOrInitScope(scopeClass);
    }

    protected MadvocScope getOrInitScope(Class<? extends MadvocScope> madvocScopeType) {
        MadvocScope newScope;
        for (MadvocScope s : this.allScopes) {
            if (!s.getClass().equals(madvocScopeType)) continue;
            return s;
        }
        try {
            newScope = this.madpc.createBean(madvocScopeType);
        }
        catch (Exception ex) {
            throw new MadvocException("Unable to create scope: " + madvocScopeType, ex);
        }
        this.allScopes.add(newScope);
        return newScope;
    }

    public void forEachScope(Consumer<MadvocScope> madvocScopeConsumer) {
        this.allScopes.forEach(madvocScopeConsumer);
    }

    public void forScope(Class<? extends MadvocScope> scopeType, Consumer<MadvocScope> madvocScopeConsumer) {
        MadvocScope scope = this.getOrInitScope(scopeType);
        madvocScopeConsumer.accept(scope);
    }
}

