/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.ClassIntrospector;
import jodd.introspector.MethodDescriptor;
import jodd.io.findfile.ClassScanner;
import jodd.log.Logger;
import jodd.log.LoggerFactory;
import jodd.madvoc.MadvocException;
import jodd.madvoc.component.ActionConfigManager;
import jodd.madvoc.component.ActionsManager;
import jodd.madvoc.component.MadvocComponentLifecycle;
import jodd.madvoc.component.MadvocContainer;
import jodd.madvoc.meta.MadvocAction;
import jodd.madvoc.meta.MadvocComponent;
import jodd.petite.meta.PetiteInject;

public class AutomagicMadvocConfigurator
implements MadvocComponentLifecycle.Init,
MadvocComponentLifecycle.Start {
    private static final Logger log = LoggerFactory.getLogger(AutomagicMadvocConfigurator.class);
    private final ClassScanner classScanner;
    @PetiteInject
    protected ActionConfigManager actionConfigManager;
    @PetiteInject
    protected ActionsManager actionsManager;
    @PetiteInject
    protected MadvocContainer madvocContainer;
    protected String actionClassSuffix = "Action";
    protected long elapsed;
    protected static final byte[] MADVOC_COMPONENT_ANNOTATION = ClassScanner.bytecodeSignatureOfType(MadvocComponent.class);
    protected List<Runnable> webappConfigurations = new ArrayList<Runnable>();
    protected List<Runnable> madvocComponents = new ArrayList<Runnable>();

    public AutomagicMadvocConfigurator() {
        this.classScanner = new ClassScanner();
        this.classScanner.detectEntriesMode(true);
        this.classScanner.scanDefaultClasspath();
        this.registerAsConsumer(this.classScanner);
    }

    public AutomagicMadvocConfigurator(ClassScanner classScanner) {
        this.classScanner = classScanner;
        this.registerAsConsumer(classScanner);
    }

    @Override
    public void init() {
        long startTime = System.currentTimeMillis();
        try {
            log.info("Scanning...");
            this.classScanner.start();
        }
        catch (Exception ex) {
            throw new MadvocException("Scan classpath error", ex);
        }
        this.madvocComponents.forEach(Runnable::run);
        log.info("Scanning is complete.");
        this.elapsed = System.currentTimeMillis() - startTime;
    }

    @Override
    public void start() {
        long startTime = System.currentTimeMillis();
        this.webappConfigurations.forEach(Runnable::run);
        this.elapsed += System.currentTimeMillis() - startTime;
        log.info(this.createInfoMessage());
    }

    protected String createInfoMessage() {
        return "Madvoc configured in " + this.elapsed + " ms. Total actions: " + this.actionsManager.getActionsCount();
    }

    protected void registerAsConsumer(ClassScanner classScanner) {
        classScanner.registerEntryConsumer(classPathEntry -> {
            String entryName = classPathEntry.name();
            if (entryName.endsWith(this.actionClassSuffix)) {
                try {
                    this.acceptActionClass(classPathEntry.loadClass());
                }
                catch (Exception ex) {
                    log.debug("Invalid Madvoc action, ignoring: " + entryName);
                }
            } else if (classPathEntry.isTypeSignatureInUse(MADVOC_COMPONENT_ANNOTATION)) {
                try {
                    this.acceptMadvocComponentClass(classPathEntry.loadClass());
                }
                catch (Exception ex) {
                    log.debug("Invalid Madvoc component ignoring: {}" + entryName);
                }
            }
        });
    }

    protected boolean checkClass(Class clazz) {
        try {
            if (clazz.isAnonymousClass()) {
                return false;
            }
            if (clazz.isArray() || clazz.isEnum()) {
                return false;
            }
            if (clazz.isInterface()) {
                return false;
            }
            if (clazz.isLocalClass()) {
                return false;
            }
            if (clazz.isMemberClass() ^ Modifier.isStatic(clazz.getModifiers())) {
                return false;
            }
            if (clazz.isPrimitive()) {
                return false;
            }
            int modifiers = clazz.getModifiers();
            return !Modifier.isAbstract(modifiers);
        }
        catch (Throwable ignore) {
            return false;
        }
    }

    protected void acceptActionClass(Class<?> actionClass) {
        MethodDescriptor[] allMethodDescriptors;
        if (actionClass == null) {
            return;
        }
        if (!this.checkClass(actionClass)) {
            return;
        }
        if (actionClass.getAnnotation(MadvocAction.class) == null) {
            return;
        }
        ClassDescriptor cd = ClassIntrospector.get().lookup(actionClass);
        for (MethodDescriptor methodDescriptor : allMethodDescriptors = cd.getAllMethodDescriptors()) {
            Method method;
            boolean hasAnnotation;
            if (!methodDescriptor.isPublic() || !(hasAnnotation = this.actionConfigManager.hasActionAnnotationOn(method = methodDescriptor.getMethod()))) continue;
            this.webappConfigurations.add(() -> this.actionsManager.registerAction(actionClass, method, null));
        }
    }

    protected void acceptMadvocComponentClass(Class componentClass) {
        if (componentClass == null) {
            return;
        }
        if (!this.checkClass(componentClass)) {
            return;
        }
        this.madvocComponents.add(() -> this.madvocContainer.registerComponent(componentClass));
    }
}

