/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.type;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalTime;
import jodd.db.type.SqlType;

public class LocalTimeSqlType
extends SqlType<LocalTime> {
    @Override
    public void set(PreparedStatement st, int index, LocalTime value, int dbSqlType) throws SQLException {
        if (value == null) {
            st.setNull(index, dbSqlType);
            return;
        }
        if (dbSqlType == 12) {
            st.setString(index, value.toString());
            return;
        }
        st.setLong(index, value.toSecondOfDay());
    }

    @Override
    public LocalTime get(ResultSet rs, int index, int dbSqlType) throws SQLException {
        if (dbSqlType == 12) {
            String string = rs.getString(index);
            if (string == null) {
                return null;
            }
            return LocalTime.parse(string);
        }
        long time = rs.getLong(index);
        if (time == 0L && rs.wasNull()) {
            return null;
        }
        return LocalTime.ofSecondOfDay(time);
    }
}

