/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.boot.autoconfigure;

import org.apache.commons.lang3.Validate;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jodconverter.boot.autoconfigure.JodConverterRemoteProperties;
import org.jodconverter.core.DocumentConverter;
import org.jodconverter.core.office.OfficeManager;
import org.jodconverter.remote.RemoteConverter;
import org.jodconverter.remote.office.RemoteOfficeManager;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={RemoteConverter.class})
@ConditionalOnProperty(prefix="jodconverter.remote", name={"enabled"}, havingValue="true")
@EnableConfigurationProperties(value={JodConverterRemoteProperties.class})
public class JodConverterRemoteAutoConfiguration {
    private final JodConverterRemoteProperties properties;

    public JodConverterRemoteAutoConfiguration(@NonNull JodConverterRemoteProperties properties) {
        this.properties = properties;
    }

    private OfficeManager createOfficeManager() {
        Validate.notNull((Object)this.properties.getUrl(), (String)"urlConnection is required", (Object[])new Object[0]);
        RemoteOfficeManager.Builder builder = RemoteOfficeManager.builder();
        builder.urlConnection(this.properties.getUrl());
        builder.poolSize(Integer.valueOf(this.properties.getPoolSize()));
        builder.workingDir(this.properties.getWorkingDir());
        builder.taskExecutionTimeout(Long.valueOf(this.properties.getTaskExecutionTimeout()));
        builder.taskQueueTimeout(Long.valueOf(this.properties.getTaskQueueTimeout()));
        if (this.properties.getSsl() != null) {
            builder.sslConfig(this.properties.getSsl().sslConfig());
        }
        return builder.build();
    }

    @Bean(initMethod="start", destroyMethod="stop")
    @ConditionalOnMissingBean(name={"remoteOfficeManager"})
    OfficeManager remoteOfficeManager() {
        return this.createOfficeManager();
    }

    @Bean
    @ConditionalOnMissingBean(name={"remoteDocumentConverter"})
    @ConditionalOnBean(name={"remoteOfficeManager"})
    DocumentConverter remoteDocumentConverter(OfficeManager remoteOfficeManager) {
        return RemoteConverter.make((OfficeManager)remoteOfficeManager);
    }
}

