/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.boot.autoconfigure;

import java.io.InputStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jodconverter.boot.autoconfigure.JodConverterLocalProperties;
import org.jodconverter.core.DocumentConverter;
import org.jodconverter.core.document.DefaultDocumentFormatRegistryInstanceHolder;
import org.jodconverter.core.document.DocumentFormatRegistry;
import org.jodconverter.core.document.JsonDocumentFormatRegistry;
import org.jodconverter.core.office.OfficeManager;
import org.jodconverter.local.LocalConverter;
import org.jodconverter.local.office.LocalOfficeManager;
import org.jodconverter.local.office.LocalOfficeUtils;
import org.jodconverter.local.process.ProcessManager;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ResourceLoader;

@Configuration
@ConditionalOnClass(value={LocalConverter.class})
@ConditionalOnProperty(prefix="jodconverter.local", name={"enabled"}, havingValue="true")
@EnableConfigurationProperties(value={JodConverterLocalProperties.class})
public class JodConverterLocalAutoConfiguration {
    private final JodConverterLocalProperties properties;

    public JodConverterLocalAutoConfiguration(@NonNull JodConverterLocalProperties properties) {
        this.properties = properties;
    }

    private OfficeManager createOfficeManager(ProcessManager processManager) {
        LocalOfficeManager.Builder builder = LocalOfficeManager.builder();
        if (!StringUtils.isBlank((CharSequence)this.properties.getPortNumbers())) {
            builder.portNumbers(ArrayUtils.toPrimitive((Integer[])((Integer[])Stream.of(StringUtils.split((String)this.properties.getPortNumbers(), (String)", ")).map(str -> NumberUtils.toInt((String)str, (int)2002)).toArray(Integer[]::new))));
        }
        builder.officeHome(this.properties.getOfficeHome());
        builder.workingDir(this.properties.getWorkingDir());
        builder.templateProfileDir(this.properties.getTemplateProfileDir());
        builder.killExistingProcess(Boolean.valueOf(this.properties.isKillExistingProcess()));
        builder.processTimeout(Long.valueOf(this.properties.getProcessTimeout()));
        builder.processRetryInterval(Long.valueOf(this.properties.getProcessRetryInterval()));
        builder.taskExecutionTimeout(Long.valueOf(this.properties.getTaskExecutionTimeout()));
        builder.maxTasksPerProcess(Integer.valueOf(this.properties.getMaxTasksPerProcess()));
        builder.taskQueueTimeout(Long.valueOf(this.properties.getTaskQueueTimeout()));
        if (StringUtils.isBlank((CharSequence)this.properties.getProcessManagerClass())) {
            builder.processManager(processManager);
        } else {
            builder.processManager(this.properties.getProcessManagerClass());
        }
        return builder.build();
    }

    @Bean
    @ConditionalOnMissingBean(name={"processManager"})
    ProcessManager processManager() {
        return LocalOfficeUtils.findBestProcessManager();
    }

    @Bean
    @ConditionalOnMissingBean(name={"documentFormatRegistry"})
    DocumentFormatRegistry documentFormatRegistry(ResourceLoader resourceLoader) throws Exception {
        JsonDocumentFormatRegistry registry;
        if (StringUtils.isBlank((CharSequence)this.properties.getDocumentFormatRegistry())) {
            try (InputStream in = resourceLoader.getResource("classpath:document-formats.json").getInputStream();){
                registry = this.properties.getFormatOptions() == null ? JsonDocumentFormatRegistry.create((InputStream)in) : JsonDocumentFormatRegistry.create((InputStream)in, this.properties.getFormatOptions());
            }
        }
        try (InputStream in = resourceLoader.getResource(this.properties.getDocumentFormatRegistry()).getInputStream();){
            registry = this.properties.getFormatOptions() == null ? JsonDocumentFormatRegistry.create((InputStream)in) : JsonDocumentFormatRegistry.create((InputStream)in, this.properties.getFormatOptions());
        }
        DefaultDocumentFormatRegistryInstanceHolder.setInstance((DocumentFormatRegistry)registry);
        return registry;
    }

    @Bean(name={"localOfficeManager"}, initMethod="start", destroyMethod="stop")
    @ConditionalOnMissingBean(name={"localOfficeManager"})
    OfficeManager localOfficeManager(ProcessManager processManager) {
        return this.createOfficeManager(processManager);
    }

    @Bean
    @ConditionalOnMissingBean(name={"localDocumentConverter"})
    @ConditionalOnBean(name={"localOfficeManager", "documentFormatRegistry"})
    DocumentConverter localDocumentConverter(OfficeManager localOfficeManager, DocumentFormatRegistry documentFormatRegistry) {
        return ((LocalConverter.Builder)((LocalConverter.Builder)LocalConverter.builder().officeManager(localOfficeManager)).formatRegistry(documentFormatRegistry)).build();
    }
}

