/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.embedded.output;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jmxtrans.embedded.EmbeddedJmxTransException;
import org.jmxtrans.embedded.QueryResult;
import org.jmxtrans.embedded.output.AbstractOutputWriter;
import org.jmxtrans.embedded.output.OutputWriter;
import org.jmxtrans.embedded.util.io.IoUtils2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StackdriverWriter
extends AbstractOutputWriter
implements OutputWriter {
    public static final int STACKDRIVER_PROTOCOL_VERSION = 1;
    public static final String SETTING_SOURCE_INSTANCE = "source";
    public static final String SETTING_DETECT_INSTANCE = "detectInstance";
    public static final String DEFAULT_STACKDRIVER_API_URL = "https://custom-gateway.stackdriver.com/v1/custom";
    public static final String SETTING_STACKDRIVER_API_TIMEOUT_IN_MILLIS = "stackdriverApiTimeoutInMillis";
    public static final int DEFAULT_STACKDRIVER_API_TIMEOUT_IN_MILLIS = 1000;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final AtomicInteger exceptionCounter = new AtomicInteger();
    private JsonFactory jsonFactory = new JsonFactory();
    private URL url;
    private int stackdriverApiTimeoutInMillis = 1000;
    private String apiKey;
    @Nullable
    private Proxy proxy;
    @Nullable
    private String instanceId;

    @Override
    public void start() {
        try {
            this.url = new URL(this.getStringSetting("url", DEFAULT_STACKDRIVER_API_URL));
        }
        catch (MalformedURLException e) {
            throw new EmbeddedJmxTransException(e);
        }
        this.apiKey = this.getStringSetting("token");
        if (this.getStringSetting("proxyHost", null) != null && !this.getStringSetting("proxyHost").isEmpty()) {
            this.proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.getStringSetting("proxyHost"), this.getIntSetting("proxyPort")));
        }
        this.logger.info("Starting Stackdriver writer connected to '{}', proxy {} ...", (Object)this.url, (Object)this.proxy);
        this.stackdriverApiTimeoutInMillis = this.getIntSetting(SETTING_STACKDRIVER_API_TIMEOUT_IN_MILLIS, 1000);
        if (this.getStringSetting(SETTING_SOURCE_INSTANCE, null) != null && !this.getStringSetting(SETTING_SOURCE_INSTANCE).isEmpty()) {
            this.instanceId = this.getStringSetting(SETTING_SOURCE_INSTANCE);
            this.logger.info("Using instance ID {} from setting {}", (Object)this.instanceId, (Object)SETTING_SOURCE_INSTANCE);
        } else if (this.getStringSetting(SETTING_DETECT_INSTANCE, null) != null && "AWS".equalsIgnoreCase(this.getStringSetting(SETTING_DETECT_INSTANCE))) {
            this.logger.info("Detect instance set to AWS, trying to determine AWS instance ID");
            this.instanceId = this.getLocalAwsInstanceId();
            if (this.instanceId != null) {
                this.logger.info("Detected instance ID as {}", (Object)this.instanceId);
            } else {
                this.logger.info("Unable to detect AWS instance ID for this machine, sending metrics without an instance ID");
            }
        } else {
            this.instanceId = null;
            this.logger.info("No source instance ID passed, and not set to detect, sending metrics without and instance ID");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Iterable<QueryResult> results) {
        this.logger.debug("Export to '{}', proxy {} metrics {}", new Object[]{this.url, this.proxy, results});
        URLConnection urlConnection = null;
        try {
            urlConnection = this.proxy == null ? (HttpURLConnection)this.url.openConnection() : (HttpURLConnection)this.url.openConnection(this.proxy);
            ((HttpURLConnection)urlConnection).setRequestMethod("POST");
            urlConnection.setDoInput(true);
            urlConnection.setDoOutput(true);
            urlConnection.setReadTimeout(this.stackdriverApiTimeoutInMillis);
            urlConnection.setRequestProperty("content-type", "application/json; charset=utf-8");
            urlConnection.setRequestProperty("x-stackdriver-apikey", this.apiKey);
            this.serialize(results, urlConnection.getOutputStream());
            int responseCode = ((HttpURLConnection)urlConnection).getResponseCode();
            if (responseCode != 200 && responseCode != 201) {
                this.exceptionCounter.incrementAndGet();
                this.logger.warn("Failure {}:'{}' to send result to Stackdriver server '{}' with proxy {}", new Object[]{responseCode, ((HttpURLConnection)urlConnection).getResponseMessage(), this.url, this.proxy});
            }
            if (this.logger.isTraceEnabled()) {
                IoUtils2.copy(urlConnection.getInputStream(), System.out);
            }
        }
        catch (Exception e) {
            this.exceptionCounter.incrementAndGet();
            this.logger.warn("Failure to send result to Stackdriver server '{}' with proxy {}", new Object[]{this.url, this.proxy, e});
        }
        finally {
            if (urlConnection != null) {
                try {
                    InputStream in = urlConnection.getInputStream();
                    IoUtils2.copy(in, IoUtils2.nullOutputStream());
                    IoUtils2.closeQuietly(in);
                    InputStream err = ((HttpURLConnection)urlConnection).getErrorStream();
                    if (err != null) {
                        IoUtils2.copy(err, IoUtils2.nullOutputStream());
                        IoUtils2.closeQuietly(err);
                    }
                    ((HttpURLConnection)urlConnection).disconnect();
                }
                catch (IOException e) {
                    this.logger.warn("Error flushing http connection for one result, continuing");
                    this.logger.debug("Stack trace for the http connection, usually a network timeout", (Throwable)e);
                }
            }
        }
    }

    @Nullable
    private String getLocalAwsInstanceId() {
        String detectedInstanceId = null;
        try {
            String inputLine;
            URL metadataUrl = new URL("http://169.254.169.254/latest/meta-data/instance-id");
            URLConnection metadataConnection = metadataUrl.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(metadataConnection.getInputStream(), "UTF-8"));
            while ((inputLine = in.readLine()) != null) {
                detectedInstanceId = inputLine;
            }
            in.close();
        }
        catch (Exception e) {
            this.logger.warn("unable to determine AWS instance ID", (Throwable)e);
        }
        return detectedInstanceId;
    }

    public void serialize(@Nonnull Iterable<QueryResult> results, @Nonnull OutputStream out) throws IOException {
        JsonGenerator g = this.jsonFactory.createGenerator(out, JsonEncoding.UTF8);
        g.writeStartObject();
        g.writeNumberField("timestamp", System.currentTimeMillis() / 1000L);
        g.writeNumberField("proto_version", 1);
        g.writeArrayFieldStart("data");
        for (QueryResult metric : results) {
            g.writeStartObject();
            g.writeStringField("name", metric.getName());
            if (this.instanceId != null && !this.instanceId.isEmpty()) {
                g.writeStringField("instance", this.instanceId);
            }
            g.writeNumberField("collected_at", metric.getEpoch(TimeUnit.SECONDS));
            if (metric.getValue() instanceof Integer) {
                g.writeNumberField("value", ((Integer)metric.getValue()).intValue());
            } else if (metric.getValue() instanceof Long) {
                g.writeNumberField("value", ((Long)metric.getValue()).longValue());
            } else if (metric.getValue() instanceof Float) {
                g.writeNumberField("value", ((Float)metric.getValue()).floatValue());
            } else if (metric.getValue() instanceof Double) {
                g.writeNumberField("value", ((Double)metric.getValue()).doubleValue());
            }
            g.writeEndObject();
        }
        g.writeEndArray();
        g.writeEndObject();
        g.flush();
        g.close();
    }

    public int getExceptionCounter() {
        return this.exceptionCounter.get();
    }
}

