/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.embedded.output;

import java.util.HashMap;
import java.util.Map;
import org.jmxtrans.embedded.QueryResult;
import org.jmxtrans.embedded.ResultNameStrategy;
import org.jmxtrans.embedded.output.OutputWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOutputWriter
implements OutputWriter {
    public static final String SETTING_URL = "url";
    public static final String SETTING_USERNAME = "username";
    public static final String SETTING_TOKEN = "token";
    public static final String SETTING_PORT = "port";
    public static final String SETTING_HOST = "host";
    public static final String SETTING_SOCKET_FACTORY = "socketFactory";
    public static final String SETTING_USE_TLS = "useTls";
    public static final String SETTING_TLS_INSECURE = "tls.insecure";
    public static final String SETTING_TLS_TRUST_STORE = "tls.trustStore";
    public static final String SETTING_TLS_TRUST_STORE_PASSWORD = "tls.trustStorePassword";
    public static final String SETTING_TLS_KEY_STORE = "tls.keyStore";
    public static final String SETTING_TLS_KEY_STORE_PASSWORD = "tls.keyStorePassword";
    public static final String SETTING_PROXY_PORT = "proxyPort";
    public static final String SETTING_PROXY_HOST = "proxyHost";
    public static final String SETTING_NAME_PREFIX = "namePrefix";
    public static final String SETTING_PROTOCOL = "protocol";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ResultNameStrategy strategy = new ResultNameStrategy();
    private Map<String, Object> settings = new HashMap<String, Object>();
    private boolean enabled = true;

    @Override
    public void start() {
    }

    @Override
    public void stop() throws Exception {
    }

    protected int getIntSetting(String name) throws IllegalArgumentException {
        String value = this.getStringSetting(name);
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Setting '" + name + "=" + value + "' is not an integer on " + this.toString());
        }
    }

    protected int getIntSetting(String name, int defaultValue) throws IllegalArgumentException {
        if (this.settings.containsKey(name)) {
            String value = this.settings.get(name).toString();
            try {
                return Integer.parseInt(value);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Setting '" + name + "=" + value + "' is not an integer on " + this.toString());
            }
        }
        return defaultValue;
    }

    protected long getLongSetting(String name, long defaultValue) throws IllegalArgumentException {
        if (this.settings.containsKey(name)) {
            String value = this.settings.get(name).toString();
            try {
                return Long.parseLong(value);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Setting '" + name + "=" + value + "' is not a long on " + this.toString());
            }
        }
        return defaultValue;
    }

    protected boolean getBooleanSetting(String name, boolean defaultValue) {
        if (this.settings.containsKey(name)) {
            String value = this.settings.get(name).toString();
            return Boolean.parseBoolean(value);
        }
        return defaultValue;
    }

    protected String getStringSetting(String name) throws IllegalArgumentException {
        if (!this.settings.containsKey(name)) {
            throw new IllegalArgumentException("No setting '" + name + "' found");
        }
        return this.settings.get(name).toString();
    }

    protected String getStringSetting(String name, String defaultValue) {
        if (this.settings.containsKey(name)) {
            return this.settings.get(name).toString();
        }
        return defaultValue;
    }

    @Override
    public abstract void write(Iterable<QueryResult> var1);

    public String toString() {
        return this.getClass().getName() + "{" + "enabled=" + this.enabled + ", settings=" + this.settings + '}';
    }

    @Override
    public Map<String, Object> getSettings() {
        return this.settings;
    }

    @Override
    public void setSettings(Map<String, Object> settings) {
        this.settings = settings;
    }

    public ResultNameStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(ResultNameStrategy strategy) {
        this.strategy = strategy;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractOutputWriter that = (AbstractOutputWriter)o;
        return this.settings.equals(that.settings);
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

