/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.extras;

import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.IXMLWriter;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.impl.MarshallingContext;
import org.jibx.runtime.impl.UnmarshallingContext;

public class QName {
    private String m_uri;
    private String m_prefix;
    private String m_name;

    public QName() {
    }

    public QName(String uri, String prefix, String name) {
        this.m_uri = uri;
        this.m_prefix = prefix;
        this.m_name = name;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getPrefix() {
        return this.m_prefix;
    }

    public void setPrefix(String prefix) {
        this.m_prefix = prefix;
    }

    public String getUri() {
        return this.m_uri;
    }

    public void setUri(String uri) {
        this.m_uri = uri;
    }

    public static QName deserialize(String text, IUnmarshallingContext ictx) throws JiBXException {
        int split = text.indexOf(58);
        if (split > 0) {
            String prefix = text.substring(0, split);
            if ((text = text.substring(split + 1)).indexOf(58) >= 0) {
                throw new JiBXException("Not a valid QName");
            }
            String uri = ((UnmarshallingContext)ictx).getNamespaceUri(prefix);
            if (uri == null) {
                throw new JiBXException("Undefined prefix " + prefix);
            }
            return new QName(uri, prefix, text);
        }
        String uri = ((UnmarshallingContext)ictx).getNamespaceUri("");
        if (uri == null) {
            uri = "";
        }
        return new QName(uri, "", text);
    }

    public static String serialize(QName qname, IMarshallingContext ictx) throws JiBXException {
        IXMLWriter ixw = ((MarshallingContext)ictx).getXmlWriter();
        int index = -1;
        int tryidx = ixw.getPrefixIndex(qname.m_prefix);
        if (tryidx >= 0 && qname.m_uri.equals(ixw.getNamespaceUri(tryidx))) {
            index = tryidx;
        }
        if (index < 0) {
            String[][] nsss;
            String[] nss = ixw.getNamespaces();
            for (int i = 0; i < nss.length; ++i) {
                if (!nss[i].equals(qname.m_uri)) continue;
                index = i;
                break;
            }
            if (index < 0 && (nsss = ixw.getExtensionNamespaces()) != null) {
                int base = nss.length;
                block1: for (int i = 0; i < nsss.length; ++i) {
                    nss = nsss[i];
                    for (int j = 0; j < nss.length; ++j) {
                        if (!nss[j].equals(qname.m_uri)) continue;
                        index = base + j;
                        break block1;
                    }
                    base += nss.length;
                }
            }
        }
        if (index >= 0) {
            String prefix = ixw.getNamespacePrefix(index);
            if (prefix == null) {
                throw new JiBXException("Namespace URI " + qname.m_uri + " cannot be used since it is not active");
            }
            if (prefix.length() > 0) {
                return prefix + ':' + qname.m_name;
            }
            return qname.m_name;
        }
        throw new JiBXException("Unknown namespace URI " + qname.m_uri);
    }
}

