/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.extras;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class DocumentComparator {
    protected XmlPullParser m_parserA;
    protected XmlPullParser m_parserB;
    protected PrintStream m_differencePrint;

    public DocumentComparator(PrintStream print) throws XmlPullParserException {
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
        factory.setNamespaceAware(true);
        this.m_parserA = factory.newPullParser();
        this.m_parserB = factory.newPullParser();
        this.m_differencePrint = print;
    }

    protected String buildPositionString(XmlPullParser parser) {
        return " line " + parser.getLineNumber() + ", col " + parser.getColumnNumber();
    }

    protected String buildName(String ns, String name) {
        if ("".equals(ns)) {
            return name;
        }
        return "{" + ns + '}' + name;
    }

    protected void printError(String msg) {
        if (this.m_differencePrint != null) {
            this.m_differencePrint.println(msg + " - from " + this.buildPositionString(this.m_parserA) + " to " + this.buildPositionString(this.m_parserB));
        }
    }

    protected boolean matchAttributes() {
        int i;
        int counta = this.m_parserA.getAttributeCount();
        int countb = this.m_parserB.getAttributeCount();
        boolean[] flags = new boolean[countb];
        boolean match = true;
        for (i = 0; i < counta; ++i) {
            String name = this.m_parserA.getAttributeName(i);
            String ns = this.m_parserA.getAttributeNamespace(i);
            String value = this.m_parserA.getAttributeValue(i);
            boolean found = false;
            for (int j = 0; j < countb; ++j) {
                if (!name.equals(this.m_parserB.getAttributeName(j)) || !ns.equals(this.m_parserB.getAttributeNamespace(j))) continue;
                flags[j] = true;
                if (!value.equals(this.m_parserB.getAttributeValue(j))) {
                    if (match) {
                        this.printError("Attribute mismatch");
                        match = false;
                    }
                    this.m_differencePrint.println("  attribute " + this.buildName(ns, name) + " value '" + value + "' != '" + this.m_parserB.getAttributeValue(j) + '\'');
                }
                found = true;
                break;
            }
            if (found) continue;
            if (match) {
                this.printError("Attribute mismatch");
                match = false;
            }
            this.m_differencePrint.println("  attribute " + this.buildName(ns, name) + " is missing from second document");
        }
        for (i = 0; i < countb; ++i) {
            if (flags[i]) continue;
            if (match) {
                this.printError("Attribute mismatch");
                match = false;
            }
            this.m_differencePrint.println("  attribute " + this.buildName(this.m_parserB.getAttributeNamespace(i), this.m_parserB.getAttributeName(i)) + " is missing from first document");
        }
        return match;
    }

    protected boolean matchText(String texta, String textb, String lead) {
        if (texta.trim().equals(textb.trim())) {
            return true;
        }
        this.printError(lead);
        if (this.m_differencePrint != null) {
            this.m_differencePrint.println(" \"" + texta + "\" (length " + texta.length() + " vs. \"" + textb + "\" (length " + textb.length() + ')');
        }
        return false;
    }

    protected boolean matchNames() {
        return this.m_parserA.getName().equals(this.m_parserB.getName()) && this.m_parserA.getNamespace().equals(this.m_parserB.getNamespace());
    }

    public boolean compare(Reader rdra, Reader rdrb) {
        try {
            this.m_parserA.setInput(rdra);
            this.m_parserB.setInput(rdrb);
            boolean content = false;
            String texta = "";
            String textb = "";
            boolean same = true;
            while (true) {
                int typeb;
                int typea;
                if (this.m_parserA.getEventType() == 4) {
                    texta = this.m_parserA.getText();
                    this.m_parserA.next();
                }
                if (this.m_parserB.getEventType() == 4) {
                    textb = this.m_parserB.getText();
                    this.m_parserB.next();
                }
                if ((typea = this.m_parserA.getEventType()) != (typeb = this.m_parserB.getEventType())) {
                    this.printError("Different document structure");
                    return false;
                }
                if (typea == 2) {
                    content = true;
                    if (!this.matchNames()) {
                        this.printError("Different start tags");
                        return false;
                    }
                    if (!this.matchAttributes()) {
                        same = false;
                    }
                    if (!this.matchText(texta, textb, "Different text content between elements")) {
                        same = false;
                    }
                    textb = "";
                    texta = "";
                } else if (typea == 3) {
                    if (!this.matchNames()) {
                        this.printError("Different end tags");
                        return false;
                    }
                    if (content) {
                        if (!this.matchText(texta, textb, "Different text content")) {
                            same = false;
                        }
                        content = false;
                    } else if (!this.matchText(texta, textb, "Different text content between elements")) {
                        same = false;
                    }
                    textb = "";
                    texta = "";
                } else if (typea == 1) {
                    return same;
                }
                this.m_parserA.next();
                this.m_parserB.next();
            }
        }
        catch (IOException ex) {
            if (this.m_differencePrint != null) {
                ex.printStackTrace(this.m_differencePrint);
            }
            return false;
        }
        catch (XmlPullParserException ex) {
            if (this.m_differencePrint != null) {
                ex.printStackTrace(this.m_differencePrint);
            }
            return false;
        }
    }
}

