/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.io.Serializable;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

@XStreamAlias(value="vcs")
public class Vcs
implements Serializable {
    private String revision = "";
    private String message = "";
    private String branch = "";
    private String url = "";

    public Vcs() {
    }

    public Vcs(String vcsUrl, String vcsRevision) {
        this.setUrl(vcsUrl);
        this.setRevision(vcsRevision);
    }

    public Vcs(String vcsUrl, String vcsRevision, String branch, String message) {
        this(vcsUrl, vcsRevision);
        this.branch = branch;
        this.message = message;
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String toString() {
        return "revision='" + this.revision + '\'' + ", commit message=" + this.message + '\'' + ", branch='" + this.branch + '\'' + ", url='" + this.url + '\'';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Vcs)) {
            return false;
        }
        Vcs that = (Vcs)o;
        return Objects.equals(this.revision, that.revision) && Objects.equals(this.branch, that.branch) && Objects.equals(this.message, that.message) && Objects.equals(this.url, that.url);
    }

    public int hashCode() {
        return Objects.hash(this.revision, this.branch, this.message, this.url);
    }

    @JsonIgnore
    public boolean isEmpty() {
        return StringUtils.isEmpty((CharSequence)this.getRevision()) && StringUtils.isEmpty((CharSequence)this.getBranch()) && StringUtils.isEmpty((CharSequence)this.getMessage()) && StringUtils.isEmpty((CharSequence)this.getUrl());
    }
}

