/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.base.typedGeometry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jetbrains.datalore.base.algorithms.GeometryKt;
import jetbrains.datalore.base.geometry.DoubleRectangles;
import jetbrains.datalore.base.typedGeometry.AlgorithmsKt;
import jetbrains.datalore.base.typedGeometry.MultiPolygon;
import jetbrains.datalore.base.typedGeometry.Polygon;
import jetbrains.datalore.base.typedGeometry.Rect;
import jetbrains.datalore.base.typedGeometry.Ring;
import jetbrains.datalore.base.typedGeometry.Vec;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\u001a&\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0007\"\u0004\b\u0000\u0010\u00022\u0012\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u00030\t\u001a$\u0010\n\u001a\n\u0012\u0004\u0012\u0002H\f\u0018\u00010\u000b\"\u0004\b\u0000\u0010\f*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\f0\u00030\r\"!\u0010\u0000\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u000e"}, d2={"length", "", "T", "Ljetbrains/datalore/base/typedGeometry/Vec;", "getLength", "(Ljetbrains/datalore/base/typedGeometry/Vec;)D", "createMultiPolygon", "Ljetbrains/datalore/base/typedGeometry/MultiPolygon;", "points", "", "boundingBox", "Ljetbrains/datalore/base/typedGeometry/Rect;", "TypeT", "", "base-portable"})
public final class AlgorithmsKt {
    public static final <T> double getLength(@NotNull Vec<T> $this$length) {
        Intrinsics.checkNotNullParameter($this$length, (String)"<this>");
        return Math.sqrt($this$length.getX() * $this$length.getX() + $this$length.getY() * $this$length.getY());
    }

    @NotNull
    public static final <T> MultiPolygon<T> createMultiPolygon(@NotNull List<Vec<T>> points) {
        Intrinsics.checkNotNullParameter(points, (String)"points");
        if (points.isEmpty()) {
            return new MultiPolygon(CollectionsKt.emptyList());
        }
        ArrayList polygons = new ArrayList();
        ArrayList rings = new ArrayList();
        for (List list : GeometryKt.splitRings(points)) {
            if (!((Collection)rings).isEmpty() && GeometryKt.isClockwise(list, (Function1)createMultiPolygon.1.INSTANCE, (Function1)createMultiPolygon.2.INSTANCE)) {
                polygons.add(new Polygon(rings));
                rings = new ArrayList();
            }
            rings.add(new Ring(list));
        }
        if (!((Collection)rings).isEmpty()) {
            polygons.add(new Polygon(rings));
        }
        return new MultiPolygon(polygons);
    }

    @Nullable
    public static final <TypeT> Rect<TypeT> boundingBox(@NotNull Iterable<Vec<TypeT>> $this$boundingBox) {
        Intrinsics.checkNotNullParameter($this$boundingBox, (String)"<this>");
        return (Rect)DoubleRectangles.INSTANCE.calculateBoundingBox($this$boundingBox, (Function1)boundingBox.1.INSTANCE, (Function1)boundingBox.2.INSTANCE, (Function4)new Function4<Double, Double, Double, Double, Rect<TypeT>>(Rect.Companion){

            @NotNull
            public final Rect<TypeT> invoke(double p0, double p1, double p2, double p3) {
                return ((Rect.Companion)this.receiver).LTRB(p0, p1, p2, p3);
            }
        });
    }
}

