/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.utils;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.InternalKotlinGradlePluginApi;
import org.jetbrains.kotlin.gradle.plugin.mpp.BitcodeEmbeddingMode;
import org.jetbrains.kotlin.konan.target.Architecture;
import org.jetbrains.kotlin.konan.target.CompilerOutputKind;
import org.jetbrains.kotlin.konan.target.Family;
import org.jetbrains.kotlin.konan.target.KonanTarget;
import org.jetbrains.kotlin.konan.target.XcodeVersion;

@InternalKotlinGradlePluginApi
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00042\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u001a\u0010\u000e\u001a\u00020\r2\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/gradle/utils/XcodeUtils;", "", "()V", "bitcodeEmbeddingMode", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/BitcodeEmbeddingMode;", "outputKind", "Lorg/jetbrains/kotlin/konan/target/CompilerOutputKind;", "userMode", "xcodeVersion", "Lorg/jetbrains/kotlin/konan/target/XcodeVersion;", "target", "Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "debuggable", "", "bitcodeSupported", "kotlin-gradle-plugin_common"})
public final class XcodeUtils {
    @NotNull
    public static final XcodeUtils INSTANCE = new XcodeUtils();

    private XcodeUtils() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final BitcodeEmbeddingMode bitcodeEmbeddingMode(@NotNull CompilerOutputKind outputKind2, @Nullable BitcodeEmbeddingMode userMode, @Nullable XcodeVersion xcodeVersion, @NotNull KonanTarget target2, boolean debuggable2) {
        BitcodeEmbeddingMode bitcodeEmbeddingMode;
        Intrinsics.checkNotNullParameter((Object)outputKind2, (String)"outputKind");
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        if (outputKind2 != CompilerOutputKind.FRAMEWORK) {
            bitcodeEmbeddingMode = BitcodeEmbeddingMode.DISABLE;
            return bitcodeEmbeddingMode;
        } else {
            bitcodeEmbeddingMode = userMode;
            if (bitcodeEmbeddingMode != null) return bitcodeEmbeddingMode;
            if (this.bitcodeSupported(xcodeVersion, target2)) {
                boolean bl = debuggable2;
                if (bl) {
                    bitcodeEmbeddingMode = BitcodeEmbeddingMode.MARKER;
                    return bitcodeEmbeddingMode;
                } else {
                    if (bl) throw new NoWhenBranchMatchedException();
                    bitcodeEmbeddingMode = BitcodeEmbeddingMode.BITCODE;
                }
                return bitcodeEmbeddingMode;
            } else {
                bitcodeEmbeddingMode = BitcodeEmbeddingMode.DISABLE;
            }
        }
        return bitcodeEmbeddingMode;
    }

    private final boolean bitcodeSupported(XcodeVersion xcodeVersion, KonanTarget target2) {
        Object[] objectArray;
        return xcodeVersion != null && xcodeVersion.getMajor() < 14 && CollectionsKt.listOf((Object[])(objectArray = new Family[]{Family.IOS, Family.WATCHOS, Family.TVOS})).contains(target2.getFamily()) && CollectionsKt.listOf((Object[])(objectArray = new Architecture[]{Architecture.ARM32, Architecture.ARM64})).contains(target2.getArchitecture());
    }
}

