/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.utils;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.zip.CRC32;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0006H\u0000\u001a\f\u0010\u0007\u001a\u00020\u0006*\u00020\bH\u0000\u001a\f\u0010\t\u001a\u00020\u0003*\u00020\bH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"checksumStringEncoder", "Ljava/util/Base64$Encoder;", "checksumString", "", "checksum", "", "", "crc32Checksum", "Ljava/io/File;", "crc32ChecksumString", "kotlin-gradle-plugin_common"})
public final class ChecksumUtilsKt {
    @NotNull
    private static final Base64.Encoder checksumStringEncoder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int crc32Checksum(@NotNull File $this$crc32Checksum) {
        Intrinsics.checkNotNullParameter((Object)$this$crc32Checksum, (String)"<this>");
        CRC32 crc32 = new CRC32();
        byte[] buffer = new byte[2048];
        Closeable closeable = new BufferedInputStream(new FileInputStream($this$crc32Checksum));
        Throwable throwable = null;
        try {
            int read;
            BufferedInputStream fileStream = (BufferedInputStream)closeable;
            boolean bl = false;
            while ((read = fileStream.read(buffer)) >= 0) {
                crc32.update(buffer, 0, read);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return (int)crc32.getValue();
    }

    @NotNull
    public static final String crc32ChecksumString(@NotNull File $this$crc32ChecksumString) {
        Intrinsics.checkNotNullParameter((Object)$this$crc32ChecksumString, (String)"<this>");
        return ChecksumUtilsKt.checksumString(ChecksumUtilsKt.crc32Checksum($this$crc32ChecksumString));
    }

    @NotNull
    public static final String checksumString(int checksum2) {
        byte[] byArray = ByteBuffer.allocate(4).putInt(checksum2).array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"allocate(4).putInt(checksum).array()");
        return ChecksumUtilsKt.checksumString(byArray);
    }

    @NotNull
    public static final String checksumString(@NotNull byte[] checksum2) {
        Intrinsics.checkNotNullParameter((Object)checksum2, (String)"checksum");
        String string = checksumStringEncoder.encodeToString(checksum2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"checksumStringEncoder.encodeToString(checksum)");
        return string;
    }

    static {
        Base64.Encoder encoder = Base64.getUrlEncoder().withoutPadding();
        Intrinsics.checkNotNullExpressionValue((Object)encoder, (String)"getUrlEncoder().withoutPadding()");
        checksumStringEncoder = encoder;
    }
}

