/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.mpp.apple.swiftexport.tasks;

import java.io.File;
import java.lang.reflect.Type;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.google.gson.reflect.TypeToken;
import org.jetbrains.kotlin.gradle.plugin.mpp.apple.ModuleMapBuilder;
import org.jetbrains.kotlin.gradle.plugin.mpp.apple.ModuleMapGenerator;
import org.jetbrains.kotlin.gradle.plugin.mpp.apple.SerializationTools;
import org.jetbrains.kotlin.gradle.plugin.mpp.apple.swiftexport.internal.GradleSwiftExportModule;
import org.jetbrains.kotlin.gradle.plugin.mpp.apple.swiftexport.tasks.GenerateSPMPackageFromSwiftExport;
import org.jetbrains.kotlin.gradle.plugin.mpp.apple.swiftexport.tasks.SPMManifestGenerator;
import org.jetbrains.kotlin.incremental.FileUtilsKt;

@DisableCachingByDefault(because="Swift Export is experimental, so no caching for now")
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b!\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020(H\u0002J\b\u0010)\u001a\u00020%H\u0002J \u0010*\u001a\u00020%2\u0006\u0010+\u001a\u00020(2\u0006\u0010,\u001a\u00020\u000e2\u0006\u0010-\u001a\u00020\u000eH\u0002J\u0016\u0010.\u001a\u00020%2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020100H\u0002J\u0016\u00102\u001a\u00020%2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020100H\u0002J\u000e\u00103\u001a\b\u0012\u0004\u0012\u00020100H\u0002J\b\u00104\u001a\u00020%H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00020\b8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\nR\u0013\u0010\u0013\u001a\u00020\b8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\nR\u001c\u0010\u0015\u001a\n \u0016*\u0004\u0018\u00010\u000e0\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0010R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00198gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u001c\u0010\u001c\u001a\n \u0016*\u0004\u0018\u00010\u000e0\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0010R\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00198gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001bR\u0014\u0010 \u001a\u00020!8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u00065"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/mpp/apple/swiftexport/tasks/GenerateSPMPackageFromSwiftExport;", "Lorg/gradle/api/DefaultTask;", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "fileSystem", "Lorg/gradle/api/file/FileSystemOperations;", "(Lorg/gradle/api/model/ObjectFactory;Lorg/gradle/api/file/FileSystemOperations;)V", "includesPath", "Lorg/gradle/api/file/DirectoryProperty;", "getIncludesPath", "()Lorg/gradle/api/file/DirectoryProperty;", "kotlinRuntime", "getKotlinRuntime", "kotlinRuntimeModule", "", "getKotlinRuntimeModule", "()Ljava/lang/String;", "packagePath", "getPackagePath", "sourcesPath", "getSourcesPath", "swiftApiModule", "kotlin.jvm.PlatformType", "getSwiftApiModule", "swiftApiModuleName", "Lorg/gradle/api/provider/Property;", "getSwiftApiModuleName", "()Lorg/gradle/api/provider/Property;", "swiftLibrary", "getSwiftLibrary", "swiftLibraryName", "getSwiftLibraryName", "swiftModulesFile", "Lorg/gradle/api/file/RegularFileProperty;", "getSwiftModulesFile", "()Lorg/gradle/api/file/RegularFileProperty;", "appendToOtherIncludes", "", "name", "path", "Ljava/io/File;", "createKotlinRuntimeTarget", "createModuleMap", "modulePath", "moduleName", "linkModule", "createPackageManifest", "modules", "", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/apple/swiftexport/internal/GradleSwiftExportModule;", "createSPMSources", "deserializeSwiftModules", "generate", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nGenerateSPMPackageFromSwiftExport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenerateSPMPackageFromSwiftExport.kt\norg/jetbrains/kotlin/gradle/plugin/mpp/apple/swiftexport/tasks/GenerateSPMPackageFromSwiftExport\n+ 2 SerializationTools.kt\norg/jetbrains/kotlin/gradle/plugin/mpp/apple/SerializationTools\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,213:1\n33#2,2:214\n1855#3:216\n1856#3:218\n1#4:217\n*S KotlinDebug\n*F\n+ 1 GenerateSPMPackageFromSwiftExport.kt\norg/jetbrains/kotlin/gradle/plugin/mpp/apple/swiftexport/tasks/GenerateSPMPackageFromSwiftExport\n*L\n75#1:214,2\n80#1:216\n80#1:218\n*E\n"})
public abstract class GenerateSPMPackageFromSwiftExport
extends DefaultTask {
    @NotNull
    private final FileSystemOperations fileSystem;
    @NotNull
    private final DirectoryProperty includesPath;
    @NotNull
    private final DirectoryProperty sourcesPath;

    /*
     * WARNING - void declaration
     */
    @Inject
    public GenerateSPMPackageFromSwiftExport(@NotNull ObjectFactory objectFactory, @NotNull FileSystemOperations fileSystem) {
        void $this$sourcesPath_u24lambda_u241;
        DirectoryProperty $this$includesPath_u24lambda_u240;
        DirectoryProperty directoryProperty;
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.fileSystem = fileSystem;
        this.onlyIf(1.INSTANCE);
        DirectoryProperty directoryProperty2 = directoryProperty = objectFactory.directoryProperty();
        GenerateSPMPackageFromSwiftExport generateSPMPackageFromSwiftExport = this;
        boolean bl = false;
        $this$includesPath_u24lambda_u240.set(this.getPackagePath().dir("OtherIncludes"));
        DirectoryProperty directoryProperty3 = directoryProperty;
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty3, (String)"objectFactory.directoryP\u2026r(\"OtherIncludes\"))\n    }");
        generateSPMPackageFromSwiftExport.includesPath = directoryProperty3;
        $this$includesPath_u24lambda_u240 = directoryProperty = objectFactory.directoryProperty();
        generateSPMPackageFromSwiftExport = this;
        boolean bl2 = false;
        $this$sourcesPath_u24lambda_u241.set(this.getPackagePath().dir("Sources"));
        DirectoryProperty directoryProperty4 = directoryProperty;
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty4, (String)"objectFactory.directoryP\u2026ath.dir(\"Sources\"))\n    }");
        generateSPMPackageFromSwiftExport.sourcesPath = directoryProperty4;
    }

    @Input
    @NotNull
    public abstract Property<String> getSwiftApiModuleName();

    @Input
    @NotNull
    public abstract Property<String> getSwiftLibraryName();

    @InputDirectory
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract DirectoryProperty getKotlinRuntime();

    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract RegularFileProperty getSwiftModulesFile();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getPackagePath();

    @OutputDirectory
    @NotNull
    public final DirectoryProperty getIncludesPath() {
        return this.includesPath;
    }

    @OutputDirectory
    @NotNull
    public final DirectoryProperty getSourcesPath() {
        return this.sourcesPath;
    }

    private final String getSwiftLibrary() {
        return (String)this.getSwiftLibraryName().get();
    }

    private final String getSwiftApiModule() {
        return (String)this.getSwiftApiModuleName().get();
    }

    private final String getKotlinRuntimeModule() {
        String string = org.jetbrains.kotlin.gradle.utils.FileUtilsKt.getDirectoryAsFile((Provider<Directory>)((Provider)this.getKotlinRuntime())).getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"kotlinRuntime.getFile().name");
        char[] cArray = new char[]{'_'};
        return CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)string, (char[])cArray, (boolean)false, (int)0, (int)6, null), (CharSequence)"", null, null, (int)0, null, (Function1)kotlinRuntimeModule.1.INSTANCE, (int)30, null);
    }

    @TaskAction
    public final void generate() {
        List<GradleSwiftExportModule> swiftModules = this.deserializeSwiftModules();
        this.createSPMSources(swiftModules);
        this.createPackageManifest(swiftModules);
        this.createKotlinRuntimeTarget();
    }

    private final List<GradleSwiftExportModule> deserializeSwiftModules() {
        String modulesFile = FilesKt.readText$default((File)org.jetbrains.kotlin.gradle.utils.FileUtilsKt.getFile((Provider<RegularFile>)((Provider)this.getSwiftModulesFile())), null, (int)1, null);
        SerializationTools this_$iv = SerializationTools.INSTANCE;
        boolean $i$f$readFromJson = false;
        Type listType$iv = new TypeToken<List<? extends GradleSwiftExportModule>>(){}.getType();
        Object t = SerializationTools.access$getGson(this_$iv).fromJson(modulesFile, listType$iv);
        Intrinsics.checkNotNullExpressionValue(t, (String)"gson.fromJson(jsonString, listType)");
        List swiftModules = (List)t;
        return swiftModules;
    }

    private final void createSPMSources(List<? extends GradleSwiftExportModule> modules2) {
        Iterable $this$forEach$iv = modules2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GradleSwiftExportModule module2 = (GradleSwiftExportModule)element$iv;
            boolean bl = false;
            GradleSwiftExportModule gradleSwiftExportModule = module2;
            if (gradleSwiftExportModule instanceof GradleSwiftExportModule.BridgesToKotlin) {
                File file;
                GenerateSPMPackageFromSwiftExport.createSPMSources$lambda$4$createSwiftApi(this, module2, ((GradleSwiftExportModule.BridgesToKotlin)module2).getFiles().getSwiftApi());
                File $this$createSPMSources_u24lambda_u244_u24lambda_u243 = file = FilesKt.resolve((File)org.jetbrains.kotlin.gradle.utils.FileUtilsKt.getDirectoryAsFile((Provider<Directory>)((Provider)this.sourcesPath)), (String)((GradleSwiftExportModule.BridgesToKotlin)module2).getBridgeName());
                boolean bl2 = false;
                FileUtilsKt.createDirectory((File)$this$createSPMSources_u24lambda_u244_u24lambda_u243);
                File bridgeModulePath = file;
                File includePath = FilesKt.resolve((File)bridgeModulePath, (String)"include");
                this.fileSystem.copy(new Action(module2, includePath){
                    final /* synthetic */ GradleSwiftExportModule $module;
                    final /* synthetic */ File $includePath;
                    {
                        this.$module = $module;
                        this.$includePath = $includePath;
                    }

                    public final void execute(CopySpec it) {
                        Object[] objectArray = new Object[]{((GradleSwiftExportModule.BridgesToKotlin)this.$module).getFiles().getCHeaderBridges()};
                        it.from(objectArray);
                        it.into((Object)this.$includePath);
                    }
                });
                this.createModuleMap(includePath, ((GradleSwiftExportModule.BridgesToKotlin)module2).getBridgeName(), module2.getName());
                FilesKt.writeText$default((File)FilesKt.resolve((File)bridgeModulePath, (String)"linkingStub.c"), (String)"\n", null, (int)2, null);
                this.appendToOtherIncludes(((GradleSwiftExportModule.BridgesToKotlin)module2).getBridgeName(), includePath);
                continue;
            }
            if (!(gradleSwiftExportModule instanceof GradleSwiftExportModule.SwiftOnly)) continue;
            GenerateSPMPackageFromSwiftExport.createSPMSources$lambda$4$createSwiftApi(this, module2, ((GradleSwiftExportModule.SwiftOnly)module2).getSwiftApi());
        }
    }

    private final void createModuleMap(File modulePath, String moduleName, String linkModule) {
        FilesKt.writeText$default((File)FilesKt.resolve((File)modulePath, (String)"module.modulemap"), (String)ModuleMapGenerator.INSTANCE.generateModuleMap((Function1<? super ModuleMapBuilder, Unit>)((Function1)new Function1<ModuleMapBuilder, Unit>(moduleName, linkModule){
            final /* synthetic */ String $moduleName;
            final /* synthetic */ String $linkModule;
            {
                this.$moduleName = $moduleName;
                this.$linkModule = $linkModule;
                super(1);
            }

            public final void invoke(ModuleMapBuilder $this$generateModuleMap) {
                Intrinsics.checkNotNullParameter((Object)$this$generateModuleMap, (String)"$this$generateModuleMap");
                $this$generateModuleMap.setName(this.$moduleName);
                $this$generateModuleMap.setExport("*");
                $this$generateModuleMap.setUmbrella(".");
                $this$generateModuleMap.setLink(CollectionsKt.listOf((Object)this.$linkModule));
            }
        })), null, (int)2, null);
    }

    private final void createKotlinRuntimeTarget() {
        File kotlinRuntimeModulePath = FilesKt.resolve((File)org.jetbrains.kotlin.gradle.utils.FileUtilsKt.getDirectoryAsFile((Provider<Directory>)((Provider)this.sourcesPath)), (String)this.getKotlinRuntimeModule());
        File kotlinRuntimeIncludePath = FilesKt.resolve((File)kotlinRuntimeModulePath, (String)"include");
        this.fileSystem.copy(new Action(this, kotlinRuntimeIncludePath){
            final /* synthetic */ GenerateSPMPackageFromSwiftExport this$0;
            final /* synthetic */ File $kotlinRuntimeIncludePath;
            {
                this.this$0 = $receiver;
                this.$kotlinRuntimeIncludePath = $kotlinRuntimeIncludePath;
            }

            public final void execute(CopySpec it) {
                Object[] objectArray = new Object[]{this.this$0.getKotlinRuntime()};
                it.from(objectArray);
                it.into((Object)this.$kotlinRuntimeIncludePath);
            }
        });
        FilesKt.writeText$default((File)FilesKt.resolve((File)kotlinRuntimeModulePath, (String)"linkingStub.c"), (String)"\n", null, (int)2, null);
        String string = org.jetbrains.kotlin.gradle.utils.FileUtilsKt.getDirectoryAsFile((Provider<Directory>)((Provider)this.getKotlinRuntime())).getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"kotlinRuntime.getFile().name");
        this.appendToOtherIncludes(string, kotlinRuntimeIncludePath);
    }

    private final void createPackageManifest(List<? extends GradleSwiftExportModule> modules2) {
        File manifest = FilesKt.resolve((File)org.jetbrains.kotlin.gradle.utils.FileUtilsKt.getDirectoryAsFile((Provider<Directory>)((Provider)this.getPackagePath())), (String)"Package.swift");
        String string = this.getSwiftApiModule();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"swiftApiModule");
        String string2 = this.getSwiftLibrary();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"swiftLibrary");
        String content = SPMManifestGenerator.INSTANCE.generateManifest(string, string2, this.getKotlinRuntimeModule(), modules2);
        FilesKt.writeText$default((File)manifest, (String)content, null, (int)2, null);
    }

    private final void appendToOtherIncludes(String name2, File path) {
        Directory includesPath = (Directory)this.includesPath.get();
        this.fileSystem.copy(new Action(path, includesPath, name2){
            final /* synthetic */ File $path;
            final /* synthetic */ Directory $includesPath;
            final /* synthetic */ String $name;
            {
                this.$path = $path;
                this.$includesPath = $includesPath;
                this.$name = $name;
            }

            public final void execute(CopySpec it) {
                Object[] objectArray = new Object[]{this.$path};
                it.from(objectArray);
                it.into((Object)this.$includesPath.dir(this.$name));
            }
        });
    }

    private static final void createSPMSources$lambda$4$createSwiftApi(GenerateSPMPackageFromSwiftExport this$0, GradleSwiftExportModule $module, File swiftApi) {
        File file;
        File $this$createSPMSources_u24lambda_u244_u24createSwiftApi_u24lambda_u242 = file = FilesKt.resolve((File)org.jetbrains.kotlin.gradle.utils.FileUtilsKt.getDirectoryAsFile((Provider<Directory>)((Provider)this$0.sourcesPath)), (String)$module.getName());
        boolean bl = false;
        FileUtilsKt.createDirectory((File)$this$createSPMSources_u24lambda_u244_u24createSwiftApi_u24lambda_u242);
        File swiftModulePath = file;
        this$0.fileSystem.copy(new Action(swiftApi, swiftModulePath){
            final /* synthetic */ File $swiftApi;
            final /* synthetic */ File $swiftModulePath;
            {
                this.$swiftApi = $swiftApi;
                this.$swiftModulePath = $swiftModulePath;
            }

            public final void execute(CopySpec it) {
                Object[] objectArray = new Object[]{this.$swiftApi};
                it.from(objectArray);
                it.into((Object)this.$swiftModulePath);
            }
        });
    }
}

