/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.FunctionExpressionDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.components.ExpectActualTracker;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedDeclarationStub;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J,\u0010\u0011\u001a\u00020\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u0014\u001a\u00020\u0015H\u0007J*\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u0014\u001a\u00020\u0015H\u0007\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/UnderscoreChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "expectActualTracker", "Lorg/jetbrains/kotlin/incremental/components/ExpectActualTracker;", "checkIdentifier", "identifier", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "allowSingleUnderscore", "", "checkNamed", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "frontend"})
public final class UnderscoreChecker
implements DeclarationChecker {
    public static final UnderscoreChecker INSTANCE;

    /*
     * Enabled aggressive block sorting
     */
    @JvmOverloads
    public final void checkIdentifier(@Nullable PsiElement identifier, @NotNull DiagnosticSink diagnosticHolder, @NotNull LanguageVersionSettings languageVersionSettings, boolean allowSingleUnderscore) {
        boolean isValidSingleUnderscore;
        Intrinsics.checkParameterIsNotNull((Object)diagnosticHolder, (String)"diagnosticHolder");
        Intrinsics.checkParameterIsNotNull((Object)languageVersionSettings, (String)"languageVersionSettings");
        if (identifier == null) return;
        String string = identifier.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"identifier.text");
        CharSequence charSequence = string;
        if (charSequence.length() == 0) {
            return;
        }
        boolean bl = false;
        if (bl) {
            return;
        }
        boolean bl2 = isValidSingleUnderscore = allowSingleUnderscore && Intrinsics.areEqual((Object)identifier.getText(), (Object)"_");
        if (!isValidSingleUnderscore) {
            boolean bl3;
            block5: {
                CharSequence $receiver$iv;
                String string2 = identifier.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"identifier.text");
                CharSequence charSequence2 = $receiver$iv = (CharSequence)string2;
                for (int i = 0; i < charSequence2.length(); ++i) {
                    char element$iv = charSequence2.charAt(i);
                    char it = element$iv;
                    if (it == '_') continue;
                    bl3 = false;
                    break block5;
                }
                bl3 = true;
            }
            if (bl3) {
                diagnosticHolder.report(Errors.UNDERSCORE_IS_RESERVED.on(identifier));
                return;
            }
        }
        if (!isValidSingleUnderscore) return;
        if (languageVersionSettings.supportsFeature(LanguageFeature.SingleUnderscoreForParameterName)) return;
        diagnosticHolder.report(Errors.UNSUPPORTED_FEATURE.on(identifier, (Pair<LanguageFeature, LanguageVersionSettings>)TuplesKt.to((Object)((Object)LanguageFeature.SingleUnderscoreForParameterName), (Object)languageVersionSettings)));
    }

    @JvmOverloads
    public static /* bridge */ /* synthetic */ void checkIdentifier$default(UnderscoreChecker underscoreChecker, PsiElement psiElement, DiagnosticSink diagnosticSink, LanguageVersionSettings languageVersionSettings, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        underscoreChecker.checkIdentifier(psiElement, diagnosticSink, languageVersionSettings, bl);
    }

    @JvmOverloads
    public final void checkIdentifier(@Nullable PsiElement identifier, @NotNull DiagnosticSink diagnosticHolder, @NotNull LanguageVersionSettings languageVersionSettings) {
        UnderscoreChecker.checkIdentifier$default(this, identifier, diagnosticHolder, languageVersionSettings, false, 8, null);
    }

    @JvmOverloads
    public final void checkNamed(@NotNull KtNamedDeclaration declaration, @NotNull DiagnosticSink diagnosticHolder, @NotNull LanguageVersionSettings languageVersionSettings, boolean allowSingleUnderscore) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        Intrinsics.checkParameterIsNotNull((Object)diagnosticHolder, (String)"diagnosticHolder");
        Intrinsics.checkParameterIsNotNull((Object)languageVersionSettings, (String)"languageVersionSettings");
        this.checkIdentifier(declaration.getNameIdentifier(), diagnosticHolder, languageVersionSettings, allowSingleUnderscore);
    }

    @JvmOverloads
    public static /* bridge */ /* synthetic */ void checkNamed$default(UnderscoreChecker underscoreChecker, KtNamedDeclaration ktNamedDeclaration, DiagnosticSink diagnosticSink, LanguageVersionSettings languageVersionSettings, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        underscoreChecker.checkNamed(ktNamedDeclaration, diagnosticSink, languageVersionSettings, bl);
    }

    @JvmOverloads
    public final void checkNamed(@NotNull KtNamedDeclaration declaration, @NotNull DiagnosticSink diagnosticHolder, @NotNull LanguageVersionSettings languageVersionSettings) {
        UnderscoreChecker.checkNamed$default(this, declaration, diagnosticHolder, languageVersionSettings, false, 8, null);
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder, @NotNull BindingContext bindingContext, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull ExpectActualTracker expectActualTracker) {
        Iterator<KtNamedDeclarationStub> iterator2;
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)diagnosticHolder, (String)"diagnosticHolder");
        Intrinsics.checkParameterIsNotNull((Object)bindingContext, (String)"bindingContext");
        Intrinsics.checkParameterIsNotNull((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkParameterIsNotNull((Object)expectActualTracker, (String)"expectActualTracker");
        if (declaration instanceof KtProperty && !(descriptor2 instanceof VariableDescriptor)) {
            return;
        }
        if (declaration instanceof KtCallableDeclaration) {
            iterator2 = ((KtCallableDeclaration)declaration).getValueParameters().iterator();
            while (iterator2.hasNext()) {
                KtParameter parameter;
                KtParameter ktParameter = parameter = (KtParameter)iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)ktParameter, (String)"parameter");
                this.checkNamed(ktParameter, diagnosticHolder, languageVersionSettings, descriptor2 instanceof FunctionExpressionDescriptor);
            }
        }
        if (declaration instanceof KtTypeParameterListOwner) {
            iterator2 = ((KtTypeParameterListOwner)declaration).getTypeParameters().iterator();
            while (iterator2.hasNext()) {
                KtTypeParameter typeParameter;
                KtTypeParameter ktTypeParameter = typeParameter = (KtTypeParameter)iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)ktTypeParameter, (String)"typeParameter");
                UnderscoreChecker.checkNamed$default(this, ktTypeParameter, diagnosticHolder, languageVersionSettings, false, 8, null);
            }
        }
        if (!(declaration instanceof KtNamedDeclaration)) {
            return;
        }
        UnderscoreChecker.checkNamed$default(this, (KtNamedDeclaration)declaration, diagnosticHolder, languageVersionSettings, false, 8, null);
    }

    private UnderscoreChecker() {
    }

    static {
        UnderscoreChecker underscoreChecker;
        INSTANCE = underscoreChecker = new UnderscoreChecker();
    }
}

