/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiField;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiNameIdentifierOwner;
import org.jetbrains.kotlin.incremental.ChangedFiles;
import org.jetbrains.kotlin.incremental.ChangesEither;
import org.jetbrains.kotlin.incremental.FileUtilsKt;
import org.jetbrains.kotlin.incremental.ICReporter;
import org.jetbrains.kotlin.incremental.LookupSymbol;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\b\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u001a\u0010\u0014\u001a\u00020\u0015*\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0018H\u0002R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/incremental/ChangedJavaFilesProcessor;", "", "reporter", "Lorg/jetbrains/kotlin/incremental/ICReporter;", "psiFileFactory", "Lkotlin/Function1;", "Ljava/io/File;", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiFile;", "(Lorg/jetbrains/kotlin/incremental/ICReporter;Lkotlin/jvm/functions/Function1;)V", "allChangedSymbols", "", "Lorg/jetbrains/kotlin/incremental/LookupSymbol;", "getAllChangedSymbols", "()Ljava/util/Collection;", "allSymbols", "Ljava/util/HashSet;", "process", "Lorg/jetbrains/kotlin/incremental/ChangesEither;", "filesDiff", "Lorg/jetbrains/kotlin/incremental/ChangedFiles$Known;", "addLookupSymbols", "", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiClass;", "symbols", "", "incremental-compilation-impl"})
public final class ChangedJavaFilesProcessor {
    private final HashSet<LookupSymbol> allSymbols;
    private final ICReporter reporter;
    private final Function1<File, PsiFile> psiFileFactory;

    @NotNull
    public final Collection<LookupSymbol> getAllChangedSymbols() {
        return this.allSymbols;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ChangesEither process(@NotNull ChangedFiles.Known filesDiff) {
        void $receiver$iv$iv;
        void $receiver$iv$iv2;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)filesDiff, (String)"filesDiff");
        Iterable iterable = $receiver$iv = (Iterable)filesDiff.getModified();
        Iterable destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            File p1 = (File)element$iv$iv;
            if (!FileUtilsKt.isJavaFile(p1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List modifiedJava = (List)destination$iv$iv;
        Iterable $receiver$iv2 = filesDiff.getRemoved();
        destination$iv$iv = $receiver$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        for (Object element$iv$iv2 : $receiver$iv$iv) {
            File p1 = (File)element$iv$iv2;
            if (!FileUtilsKt.isJavaFile(p1)) continue;
            destination$iv$iv2.add(element$iv$iv2);
        }
        List removedJava = (List)destination$iv$iv2;
        if (CollectionsKt.any((Iterable)removedJava)) {
            this.reporter.report((Function0<String>)((Function0)new Function0<String>(removedJava){
                final /* synthetic */ List $removedJava;

                @NotNull
                public final String invoke() {
                    return "Some java files are removed: [" + CollectionsKt.joinToString$default((Iterable)this.$removedJava, null, null, null, (int)0, null, null, (int)63, null) + ']';
                }
                {
                    this.$removedJava = list2;
                    super(0);
                }
            }));
            return new ChangesEither.Unknown();
        }
        HashSet symbols = new HashSet();
        for (File javaFile : modifiedJava) {
            boolean element$iv$iv = StringsKt.equals((String)FilesKt.getExtension((File)javaFile), (String)"java", (boolean)true);
            if (_Assertions.ENABLED && !element$iv$iv) {
                Object element$iv$iv2;
                element$iv$iv2 = "Assertion failed";
                throw (Throwable)((Object)new AssertionError(element$iv$iv2));
            }
            PsiFile psiFile = (PsiFile)this.psiFileFactory.invoke((Object)javaFile);
            if (!(psiFile instanceof PsiJavaFile)) {
                this.reporter.report((Function0<String>)((Function0)new Function0<String>(psiFile){
                    final /* synthetic */ PsiFile $psiFile;

                    @NotNull
                    public final String invoke() {
                        PsiFile psiFile = this.$psiFile;
                        return "Expected PsiJavaFile, got " + (psiFile != null ? psiFile.getClass() : null);
                    }
                    {
                        this.$psiFile = psiFile;
                        super(0);
                    }
                }));
                return new ChangesEither.Unknown();
            }
            PsiClass[] psiClassArray = ((PsiJavaFile)psiFile).getClasses();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiClassArray, (String)"psiFile.classes");
            for (Object element$iv : (Object[])psiClassArray) {
                PsiClass it;
                PsiClass psiClass = it = (PsiClass)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiClass, (String)"it");
                this.addLookupSymbols(psiClass, symbols);
            }
        }
        this.allSymbols.addAll(symbols);
        return new ChangesEither.Known(symbols, null, 2, null);
    }

    private final void addLookupSymbols(@NotNull PsiClass $receiver, Set<LookupSymbol> symbols) {
        PsiNameIdentifierOwner it;
        String string;
        String string2;
        String string3 = $receiver.getQualifiedName();
        String string4 = string3;
        if (string4 == null) {
            string4 = "";
        }
        String fqn = string4;
        string3 = $receiver.getName();
        Set<LookupSymbol> set = symbols;
        String string5 = string3;
        if (string5 == null) {
            string5 = string2 = "";
        }
        if (Intrinsics.areEqual((Object)fqn, (Object)$receiver.getName())) {
            string = "";
        } else {
            StringBuilder stringBuilder = new StringBuilder().append(".");
            String string6 = $receiver.getName();
            if (string6 == null) {
                Intrinsics.throwNpe();
            }
            string = StringsKt.removeSuffix((String)fqn, (CharSequence)stringBuilder.append(string6).toString());
        }
        String string7 = string;
        String string8 = string2;
        set.add(new LookupSymbol(string8, string7));
        PsiMethod[] psiMethodArray = $receiver.getMethods();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiMethodArray, (String)"methods");
        for (Object element$iv : (Object[])psiMethodArray) {
            it = (PsiMethod)element$iv;
            PsiMethod psiMethod = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiMethod, (String)"it");
            String string9 = psiMethod.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"it.name");
            symbols.add(new LookupSymbol(string9, fqn));
        }
        PsiField[] psiFieldArray = $receiver.getFields();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFieldArray, (String)"fields");
        for (Object element$iv : (Object[])psiFieldArray) {
            PsiNameIdentifierOwner psiNameIdentifierOwner = it = (PsiField)element$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiNameIdentifierOwner, (String)"it");
            String $i$a$1$forEach = psiNameIdentifierOwner.getName();
            Set<LookupSymbol> set2 = symbols;
            String string10 = $i$a$1$forEach;
            if (string10 == null) {
                string10 = "";
            }
            String string11 = string10;
            String string12 = fqn;
            String string13 = string11;
            set2.add(new LookupSymbol(string13, string12));
        }
        PsiClass[] psiClassArray = $receiver.getInnerClasses();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiClassArray, (String)"innerClasses");
        for (Object element$iv : (Object[])psiClassArray) {
            PsiNameIdentifierOwner psiNameIdentifierOwner = it = (PsiClass)element$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiNameIdentifierOwner, (String)"it");
            this.addLookupSymbols((PsiClass)psiNameIdentifierOwner, symbols);
        }
    }

    public ChangedJavaFilesProcessor(@NotNull ICReporter reporter, @NotNull Function1<? super File, ? extends PsiFile> psiFileFactory2) {
        Intrinsics.checkParameterIsNotNull((Object)reporter, (String)"reporter");
        Intrinsics.checkParameterIsNotNull(psiFileFactory2, (String)"psiFileFactory");
        this.reporter = reporter;
        this.psiFileFactory = psiFileFactory2;
        this.allSymbols = new HashSet();
    }
}

