/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.tree;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.LighterAST;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTNode;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTTokenNode;
import org.jetbrains.kotlin.com.intellij.lang.LighterLazyParseableNode;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public class LightTreeUtil {
    @Nullable
    public static LighterASTNode firstChildOfType(@NotNull LighterAST tree, @Nullable LighterASTNode node, @NotNull IElementType type2) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LightTreeUtil", "firstChildOfType"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LightTreeUtil", "firstChildOfType"));
        }
        if (node == null) {
            return null;
        }
        List<LighterASTNode> children2 = tree.getChildren(node);
        for (int i = 0; i < children2.size(); ++i) {
            LighterASTNode child = children2.get(i);
            if (child.getTokenType() != type2) continue;
            return child;
        }
        return null;
    }

    @Nullable
    public static LighterASTNode firstChildOfType(@NotNull LighterAST tree, @Nullable LighterASTNode node, @NotNull TokenSet types) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LightTreeUtil", "firstChildOfType"));
        }
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LightTreeUtil", "firstChildOfType"));
        }
        if (node == null) {
            return null;
        }
        List<LighterASTNode> children2 = tree.getChildren(node);
        for (int i = 0; i < children2.size(); ++i) {
            LighterASTNode child = children2.get(i);
            if (!types.contains(child.getTokenType())) continue;
            return child;
        }
        return null;
    }

    @NotNull
    public static LighterASTNode requiredChildOfType(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull IElementType type2) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LightTreeUtil", "requiredChildOfType"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LightTreeUtil", "requiredChildOfType"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LightTreeUtil", "requiredChildOfType"));
        }
        LighterASTNode child = LightTreeUtil.firstChildOfType(tree, node, type2);
        assert (child != null) : "Required child " + type2 + " not found in " + node.getTokenType() + ": " + tree.getChildren(node);
        LighterASTNode lighterASTNode = child;
        if (lighterASTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LightTreeUtil", "requiredChildOfType"));
        }
        return lighterASTNode;
    }

    @NotNull
    public static LighterASTNode requiredChildOfType(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull TokenSet types) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LightTreeUtil", "requiredChildOfType"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LightTreeUtil", "requiredChildOfType"));
        }
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LightTreeUtil", "requiredChildOfType"));
        }
        LighterASTNode child = LightTreeUtil.firstChildOfType(tree, node, types);
        assert (child != null) : "Required child " + types + " not found in " + node.getTokenType() + ": " + tree.getChildren(node);
        LighterASTNode lighterASTNode = child;
        if (lighterASTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LightTreeUtil", "requiredChildOfType"));
        }
        return lighterASTNode;
    }

    @NotNull
    public static List<LighterASTNode> getChildrenOfType(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull IElementType type2) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LightTreeUtil", "getChildrenOfType"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LightTreeUtil", "getChildrenOfType"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LightTreeUtil", "getChildrenOfType"));
        }
        List<LighterASTNode> result2 = null;
        List<LighterASTNode> children2 = tree.getChildren(node);
        int size = children2.size();
        for (int i = 0; i < size; ++i) {
            LighterASTNode child = children2.get(i);
            if (child.getTokenType() != type2) continue;
            if (result2 == null) {
                result2 = new SmartList<LighterASTNode>();
            }
            result2.add(child);
        }
        List<LighterASTNode> list2 = result2 != null ? result2 : Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LightTreeUtil", "getChildrenOfType"));
        }
        return list2;
    }

    @NotNull
    public static List<LighterASTNode> getChildrenOfType(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull TokenSet types) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LightTreeUtil", "getChildrenOfType"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LightTreeUtil", "getChildrenOfType"));
        }
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LightTreeUtil", "getChildrenOfType"));
        }
        List<LighterASTNode> children2 = tree.getChildren(node);
        List<LighterASTNode> result2 = null;
        int size = children2.size();
        for (int i = 0; i < size; ++i) {
            LighterASTNode child = children2.get(i);
            if (!types.contains(child.getTokenType())) continue;
            if (result2 == null) {
                result2 = new SmartList<LighterASTNode>();
            }
            result2.add(child);
        }
        List<LighterASTNode> list2 = result2 != null ? result2 : Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LightTreeUtil", "getChildrenOfType"));
        }
        return list2;
    }

    @NotNull
    public static String toFilteredString(@NotNull LighterAST tree, @NotNull LighterASTNode node, @Nullable TokenSet skipTypes) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LightTreeUtil", "toFilteredString"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LightTreeUtil", "toFilteredString"));
        }
        int length = node.getEndOffset() - node.getStartOffset();
        if (length < 0) {
            length = 0;
            Logger.getInstance(LightTreeUtil.class).error("tree=" + tree + " node=" + node);
        }
        StringBuilder buffer = new StringBuilder(length);
        LightTreeUtil.toBuffer(tree, node, buffer, skipTypes);
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LightTreeUtil", "toFilteredString"));
        }
        return string;
    }

    public static void toBuffer(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull StringBuilder buffer, @Nullable TokenSet skipTypes) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LightTreeUtil", "toBuffer"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LightTreeUtil", "toBuffer"));
        }
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LightTreeUtil", "toBuffer"));
        }
        if (skipTypes != null && skipTypes.contains(node.getTokenType())) {
            return;
        }
        if (node instanceof LighterASTTokenNode) {
            buffer.append(((LighterASTTokenNode)node).getText());
            return;
        }
        if (node instanceof LighterLazyParseableNode) {
            buffer.append(((LighterLazyParseableNode)node).getText());
            return;
        }
        List<LighterASTNode> children2 = tree.getChildren(node);
        int size = children2.size();
        for (int i = 0; i < size; ++i) {
            LightTreeUtil.toBuffer(tree, children2.get(i), buffer, skipTypes);
        }
    }

    @Nullable
    public static LighterASTNode getParentOfType(@NotNull LighterAST tree, @Nullable LighterASTNode node, @NotNull TokenSet types, @NotNull TokenSet stopAt) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LightTreeUtil", "getParentOfType"));
        }
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LightTreeUtil", "getParentOfType"));
        }
        if (stopAt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stopAt", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LightTreeUtil", "getParentOfType"));
        }
        if (node == null) {
            return null;
        }
        node = tree.getParent(node);
        while (node != null) {
            IElementType type2 = node.getTokenType();
            if (types.contains(type2)) {
                return node;
            }
            if (stopAt.contains(type2)) {
                return null;
            }
            node = tree.getParent(node);
        }
        return null;
    }

    @Nullable
    public static LighterASTNode findLeafElementAt(@NotNull LighterAST tree, int offset2) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LightTreeUtil", "findLeafElementAt"));
        }
        LighterASTNode eachNode = tree.getRoot();
        if (!LightTreeUtil.containsOffset(eachNode, offset2)) {
            return null;
        }
        while (eachNode != null) {
            List<LighterASTNode> children2 = tree.getChildren(eachNode);
            if (children2.isEmpty()) {
                return eachNode;
            }
            eachNode = LightTreeUtil.findChildAtOffset(offset2, children2);
        }
        return null;
    }

    private static LighterASTNode findChildAtOffset(int offset2, List<LighterASTNode> children2) {
        return ContainerUtil.find(children2, node -> LightTreeUtil.containsOffset(node, offset2));
    }

    private static boolean containsOffset(LighterASTNode node, int offset2) {
        return node.getStartOffset() <= offset2 && node.getEndOffset() > offset2;
    }
}

