/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.istio.common;

import com.alibaba.nacos.istio.common.NacosResourceManager;
import com.alibaba.nacos.istio.model.IstioService;
import com.alibaba.nacos.istio.model.ServiceEntryWrapper;
import com.alibaba.nacos.istio.util.IstioCrdUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class ResourceSnapshot {
    private static AtomicLong versionSuffix = new AtomicLong(0L);
    private final List<ServiceEntryWrapper> serviceEntries = new ArrayList<ServiceEntryWrapper>();
    private boolean isCompleted = false;
    private String version;

    public synchronized void initResourceSnapshot(NacosResourceManager manager) {
        if (this.isCompleted) {
            return;
        }
        this.initServiceEntry(manager);
        this.generateVersion();
        this.isCompleted = true;
    }

    private void generateVersion() {
        String time = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX").format(new Date());
        this.version = time + "/" + versionSuffix.getAndIncrement();
    }

    private void initServiceEntry(NacosResourceManager manager) {
        Map<String, IstioService> serviceInfoMap = manager.services();
        for (String serviceName : serviceInfoMap.keySet()) {
            ServiceEntryWrapper serviceEntryWrapper = IstioCrdUtil.buildServiceEntry(serviceName, manager.getIstioConfig().getDomainSuffix(), serviceInfoMap.get(serviceName));
            if (serviceEntryWrapper == null) continue;
            this.serviceEntries.add(serviceEntryWrapper);
        }
    }

    public List<ServiceEntryWrapper> getServiceEntries() {
        return this.serviceEntries;
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    public String getVersion() {
        return this.version;
    }
}

