/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.poi.util;

import java.lang.reflect.Array;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Map;
import org.jeecgframework.poi.exception.excel.ExcelExportException;

public final class PoiFunctionUtil {
    private static final String TWO_DECIMAL_STR = "###.00";
    private static final String THREE_DECIMAL_STR = "###.000";
    private static final DecimalFormat TWO_DECIMAL = new DecimalFormat("###.00");
    private static final DecimalFormat THREE_DECIMAL = new DecimalFormat("###.000");
    private static final String DAY_STR = "yyyy-MM-dd";
    private static final String TIME_STR = "yyyy-MM-dd HH:mm:ss";
    private static final String TIME__NO_S_STR = "yyyy-MM-dd HH:mm";
    private static final SimpleDateFormat DAY_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final SimpleDateFormat TIME__NO_S_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm");

    private PoiFunctionUtil() {
    }

    public static int length(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof Map) {
            return ((Map)obj).size();
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).size();
        }
        if (obj.getClass().isArray()) {
            return Array.getLength(obj);
        }
        return String.valueOf(obj).length();
    }

    public static String formatNumber(Object obj, String format) {
        if (obj == null || obj.toString() == "") {
            return "";
        }
        double number = Double.valueOf(obj.toString());
        DecimalFormat decimalFormat = null;
        decimalFormat = TWO_DECIMAL.equals(format) ? TWO_DECIMAL : (THREE_DECIMAL_STR.equals(format) ? THREE_DECIMAL : new DecimalFormat(format));
        return decimalFormat.format(number);
    }

    public static String formatDate(Object obj, String format) {
        if (obj == null || obj.toString() == "") {
            return "";
        }
        SimpleDateFormat dateFormat = null;
        dateFormat = DAY_STR.equals(format) ? DAY_FORMAT : (TIME_STR.equals(format) ? TIME_FORMAT : (TIME__NO_S_STR.equals(format) ? TIME__NO_S_FORMAT : new SimpleDateFormat(format)));
        return dateFormat.format(obj);
    }

    public static boolean isTrue(Object first, String operator, Object second) {
        if (">".endsWith(operator)) {
            return PoiFunctionUtil.isGt(first, second);
        }
        if ("<".endsWith(operator)) {
            return PoiFunctionUtil.isGt(second, first);
        }
        if ("==".endsWith(operator)) {
            if (first != null && second != null) {
                return PoiFunctionUtil.eq(first, second);
            }
            return first == second;
        }
        if ("!=".endsWith(operator)) {
            if (first != null && second != null) {
                return !first.equals(second);
            }
            return first != second;
        }
        throw new ExcelExportException("\u5360\u4e0d\u652f\u6301\u6539\u64cd\u4f5c\u7b26");
    }

    private static boolean eq(Object first, Object second) {
        if (!(first instanceof String) || !(second instanceof String)) {
            try {
                double f = Double.parseDouble(first.toString());
                double s = Double.parseDouble(second.toString());
                return f == s;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return first.equals(second);
    }

    private static boolean isGt(Object first, Object second) {
        double two;
        if (first == null || first.toString() == "") {
            return false;
        }
        if (second == null || second.toString() == "") {
            return true;
        }
        double one = Double.valueOf(first.toString());
        return one > (two = Double.valueOf(second.toString()).doubleValue());
    }
}

