/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.batch.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.jeasy.batch.core.record.Batch;
import org.jeasy.batch.core.record.Record;
import org.jeasy.batch.core.util.Utils;
import org.jeasy.batch.core.writer.RecordWriter;
import org.jeasy.batch.jdbc.PreparedStatementProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcRecordWriter<P>
implements RecordWriter<P> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)JdbcRecordWriter.class.getSimpleName());
    private DataSource dataSource;
    private Connection connection;
    private String query;
    private PreparedStatementProvider preparedStatementProvider;

    public JdbcRecordWriter(DataSource dataSource, String query, PreparedStatementProvider preparedStatementProvider) {
        Utils.checkNotNull((Object)dataSource, (String)"data source");
        Utils.checkNotNull((Object)query, (String)"query");
        Utils.checkNotNull((Object)preparedStatementProvider, (String)"prepared statement");
        this.dataSource = dataSource;
        this.query = query;
        this.preparedStatementProvider = preparedStatementProvider;
    }

    public void open() throws Exception {
        LOGGER.debug("Opening JDBC connection");
        this.connection = this.dataSource.getConnection();
        this.connection.setAutoCommit(false);
    }

    public void writeRecords(Batch<P> batch) throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(this.query);){
            for (Record record : batch) {
                this.preparedStatementProvider.prepareStatement(preparedStatement, record.getPayload());
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
            this.connection.commit();
            LOGGER.debug("Transaction committed");
        }
        catch (SQLException e) {
            LOGGER.error("Unable to commit transaction", (Throwable)e);
            this.connection.rollback();
            throw e;
        }
    }

    public void close() throws Exception {
        if (this.connection != null) {
            LOGGER.debug("Closing JDBC connection");
            this.connection.close();
        }
    }
}

