/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.batch.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import org.jeasy.batch.core.mapper.AbstractRecordMapper;
import org.jeasy.batch.core.mapper.RecordMapper;
import org.jeasy.batch.core.record.GenericRecord;
import org.jeasy.batch.core.record.Record;

public class JdbcRecordMapper<P>
extends AbstractRecordMapper<P>
implements RecordMapper<ResultSet, P> {
    private String[] fields;

    public JdbcRecordMapper(Class<P> recordClass) {
        super(recordClass);
    }

    public JdbcRecordMapper(Class<P> recordClass, String ... fields) {
        this(recordClass);
        this.fields = fields;
    }

    public Record<P> processRecord(Record<ResultSet> record) throws Exception {
        ResultSet resultSet = (ResultSet)record.getPayload();
        this.initFieldNames(resultSet);
        HashMap<String, String> values = new HashMap<String, String>();
        for (int i = 0; i < this.fields.length; ++i) {
            values.put(this.fields[i], resultSet.getString(i + 1));
        }
        return new GenericRecord(record.getHeader(), this.objectMapper.mapObject(values));
    }

    private void initFieldNames(ResultSet resultSet) throws SQLException {
        int columnCount = resultSet.getMetaData().getColumnCount();
        if (this.fields == null) {
            this.fields = new String[columnCount];
            for (int i = 1; i < columnCount + 1; ++i) {
                this.fields[i - 1] = resultSet.getMetaData().getColumnLabel(i);
            }
        }
    }
}

