/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.batch.jdbc;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.jeasy.batch.core.mapper.BeanIntrospectionException;
import org.jeasy.batch.jdbc.PreparedStatementProvider;

public class BeanPropertiesPreparedStatementProvider
implements PreparedStatementProvider {
    protected String[] properties;
    protected PropertyDescriptor[] propertyDescriptors;
    protected final Map<Class<?>, Integer> javaTypesToSqlTypes = new HashMap<Class<?>, Integer>(){
        {
            this.put(Boolean.TYPE, 16);
            this.put(Boolean.class, 16);
            this.put(Byte.TYPE, -6);
            this.put(Byte.class, -6);
            this.put(Short.TYPE, 5);
            this.put(Short.class, 5);
            this.put(Integer.TYPE, 4);
            this.put(Integer.class, 4);
            this.put(Long.TYPE, -5);
            this.put(Long.class, -5);
            this.put(BigInteger.class, -5);
            this.put(Float.TYPE, 6);
            this.put(Float.class, 6);
            this.put(Double.TYPE, 8);
            this.put(Double.class, 8);
            this.put(BigDecimal.class, 3);
            this.put(java.util.Date.class, 91);
            this.put(Calendar.class, 91);
            this.put(Date.class, 91);
            this.put(Time.class, 92);
            this.put(Timestamp.class, 93);
            this.put(LocalDate.class, 91);
            this.put(LocalTime.class, 92);
            this.put(LocalDateTime.class, 93);
            this.put(OffsetTime.class, 2013);
            this.put(OffsetDateTime.class, 2014);
            this.put(Blob.class, 2004);
            this.put(Clob.class, 2005);
            this.put(CharSequence.class, 12);
            this.put(String.class, 12);
            this.put(StringBuffer.class, 12);
            this.put(StringBuilder.class, 12);
        }
    };

    public BeanPropertiesPreparedStatementProvider(Class<?> type, String ... properties) throws BeanIntrospectionException {
        this.properties = properties;
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(type);
            this.propertyDescriptors = beanInfo.getPropertyDescriptors();
        }
        catch (IntrospectionException e) {
            throw new BeanIntrospectionException("Unable to introspect type " + type, (Throwable)e);
        }
    }

    @Override
    public void prepareStatement(PreparedStatement preparedStatement, Object record) throws SQLException {
        int index = 1;
        block2: for (String property : this.properties) {
            try {
                for (PropertyDescriptor propertyDescriptor : this.propertyDescriptors) {
                    if (!propertyDescriptor.getName().equals(property)) continue;
                    Method readMethod = propertyDescriptor.getReadMethod();
                    Integer sqlType = this.javaTypesToSqlTypes.get(readMethod.getReturnType());
                    Object value = readMethod.invoke(record, new Object[0]);
                    if (sqlType != null) {
                        preparedStatement.setObject(index++, value, sqlType);
                        continue block2;
                    }
                    preparedStatement.setObject(index++, value);
                    continue block2;
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new BeanIntrospectionException(String.format("Unable to get property %s from type %s", property, record.getClass().getName()), (Throwable)e);
            }
        }
    }
}

