/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.batch.extensions.integration.jms;

import java.util.List;
import javax.jms.Message;
import javax.jms.QueueSender;
import org.jeasy.batch.core.record.Batch;
import org.jeasy.batch.core.record.Record;
import org.jeasy.batch.core.writer.RecordWriter;

public class RoundRobinJmsQueueRecordWriter<P>
implements RecordWriter<P> {
    private int queuesNumber;
    private int next;
    private List<QueueSender> queues;

    public RoundRobinJmsQueueRecordWriter(List<QueueSender> queues) {
        this.queues = queues;
        this.queuesNumber = queues.size();
    }

    public void writeRecords(Batch<P> batch) throws Exception {
        for (Record record : batch) {
            QueueSender queue = this.queues.get(this.next++ % this.queuesNumber);
            queue.send((Message)record.getPayload());
        }
    }
}

