/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.batch.extensions.integration.jms;

import java.util.List;
import java.util.Random;
import javax.jms.Message;
import javax.jms.QueueSender;
import org.jeasy.batch.core.record.Batch;
import org.jeasy.batch.core.record.Record;
import org.jeasy.batch.core.writer.RecordWriter;

public class RandomJmsQueueRecordWriter<P>
implements RecordWriter<P> {
    private int queuesNumber;
    private List<QueueSender> queues;
    private Random random;

    public RandomJmsQueueRecordWriter(List<QueueSender> queues) {
        this.queues = queues;
        this.queuesNumber = queues.size();
        this.random = new Random();
    }

    public void writeRecords(Batch<P> batch) throws Exception {
        for (Record record : batch) {
            QueueSender queue = this.queues.get(this.random.nextInt(this.queuesNumber));
            queue.send((Message)record.getPayload());
        }
    }
}

