/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.batch.extensions.integration;

import java.util.Map;
import java.util.concurrent.BlockingQueue;
import org.jeasy.batch.core.record.Batch;
import org.jeasy.batch.core.record.Record;
import org.jeasy.batch.core.writer.RecordWriter;
import org.jeasy.batch.extensions.integration.DefaultPredicate;
import org.jeasy.batch.extensions.integration.Predicate;

public class ContentBasedBlockingQueueRecordWriter<P>
implements RecordWriter<P> {
    private Map<Predicate<P>, BlockingQueue<Record<P>>> queueMap;

    public ContentBasedBlockingQueueRecordWriter(Map<Predicate<P>, BlockingQueue<Record<P>>> queueMap) {
        this.queueMap = queueMap;
    }

    public void writeRecords(Batch<P> batch) throws Exception {
        DefaultPredicate defaultPredicate = new DefaultPredicate();
        BlockingQueue<Record<P>> defaultQueue = this.queueMap.get(defaultPredicate);
        for (Record record : batch) {
            boolean matched = false;
            for (Map.Entry<Predicate<P>, BlockingQueue<Record<P>>> entry : this.queueMap.entrySet()) {
                Predicate<P> predicate = entry.getKey();
                BlockingQueue<Record<P>> queue = entry.getValue();
                if (predicate instanceof DefaultPredicate || !predicate.matches(record)) continue;
                queue.put(record);
                matched = true;
                break;
            }
            if (matched || defaultQueue == null) continue;
            defaultQueue.put(record);
        }
    }

    public Map<Predicate<P>, BlockingQueue<Record<P>>> getQueueMap() {
        return this.queueMap;
    }
}

