/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.graph.def;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmException;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.def.DelegationException;
import org.jbpm.graph.def.Event;
import org.jbpm.graph.def.ExceptionHandler;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.RuntimeAction;
import org.jbpm.graph.exe.Token;
import org.jbpm.graph.log.ActionLog;
import org.jbpm.instantiation.UserCodeInterceptorConfig;
import org.jbpm.job.ExecuteActionJob;
import org.jbpm.msg.MessageService;
import org.jbpm.svc.Services;
import org.jbpm.util.EqualsUtil;

public abstract class GraphElement
implements Serializable {
    private static final long serialVersionUID = 1L;
    long id = 0L;
    protected String name = null;
    protected String description = null;
    protected ProcessDefinition processDefinition = null;
    protected Map events = null;
    protected List exceptionHandlers = null;
    private static final Log log = LogFactory.getLog(GraphElement.class);

    public GraphElement() {
    }

    public GraphElement(String name) {
        this.setName(name);
    }

    public abstract String[] getSupportedEventTypes();

    public Map getEvents() {
        return this.events;
    }

    public boolean hasEvents() {
        return this.events != null && this.events.size() > 0;
    }

    public Event getEvent(String eventType) {
        Event event = null;
        if (this.events != null) {
            event = (Event)this.events.get(eventType);
        }
        return event;
    }

    public boolean hasEvent(String eventType) {
        boolean hasEvent = false;
        if (this.events != null) {
            hasEvent = this.events.containsKey(eventType);
        }
        return hasEvent;
    }

    public Event addEvent(Event event) {
        if (event == null) {
            throw new IllegalArgumentException("can't add a null event to a graph element");
        }
        if (event.getEventType() == null) {
            throw new IllegalArgumentException("can't add an event without an eventType to a graph element");
        }
        if (this.events == null) {
            this.events = new HashMap();
        }
        this.events.put(event.getEventType(), event);
        event.graphElement = this;
        return event;
    }

    public Event removeEvent(Event event) {
        Event removedEvent = null;
        if (event == null) {
            throw new IllegalArgumentException("can't remove a null event from a graph element");
        }
        if (event.getEventType() == null) {
            throw new IllegalArgumentException("can't remove an event without an eventType from a graph element");
        }
        if (this.events != null && (removedEvent = (Event)this.events.remove(event.getEventType())) != null) {
            event.graphElement = null;
        }
        return removedEvent;
    }

    public List getExceptionHandlers() {
        return this.exceptionHandlers;
    }

    public ExceptionHandler addExceptionHandler(ExceptionHandler exceptionHandler) {
        if (exceptionHandler == null) {
            throw new IllegalArgumentException("can't add a null exceptionHandler to a graph element");
        }
        if (this.exceptionHandlers == null) {
            this.exceptionHandlers = new ArrayList();
        }
        this.exceptionHandlers.add(exceptionHandler);
        exceptionHandler.graphElement = this;
        return exceptionHandler;
    }

    public void removeExceptionHandler(ExceptionHandler exceptionHandler) {
        if (exceptionHandler == null) {
            throw new IllegalArgumentException("can't remove a null exceptionHandler from an graph element");
        }
        if (this.exceptionHandlers != null && this.exceptionHandlers.remove(exceptionHandler)) {
            exceptionHandler.graphElement = null;
        }
    }

    public void reorderExceptionHandler(int oldIndex, int newIndex) {
        if (this.exceptionHandlers == null || Math.min(oldIndex, newIndex) < 0 || Math.max(oldIndex, newIndex) >= this.exceptionHandlers.size()) {
            throw new IndexOutOfBoundsException("couldn't reorder element from index '" + oldIndex + "' to index '" + newIndex + "' in exceptionHandler-list '" + this.exceptionHandlers + "'");
        }
        Object o = this.exceptionHandlers.remove(oldIndex);
        this.exceptionHandlers.add(newIndex, o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireEvent(String eventType, ExecutionContext executionContext) {
        log.debug((Object)("event '" + eventType + "' on '" + this + "' for '" + executionContext.getToken() + "'"));
        try {
            executionContext.setEventSource(this);
            this.fireAndPropagateEvent(eventType, executionContext);
        }
        finally {
            executionContext.setEventSource(null);
        }
    }

    public void fireAndPropagateEvent(String eventType, ExecutionContext executionContext) {
        boolean isPropagated = !this.equals(executionContext.getEventSource());
        Event event = this.getEvent(eventType);
        if (event != null) {
            executionContext.setEvent(event);
            this.executeActions(event.getActions(), executionContext, isPropagated);
        }
        List runtimeActions = this.getRuntimeActionsForEvent(executionContext, eventType);
        this.executeActions(runtimeActions, executionContext, isPropagated);
        executionContext.setEvent(null);
        GraphElement parent = this.getParent();
        if (parent != null) {
            parent.fireAndPropagateEvent(eventType, executionContext);
        }
    }

    void executeActions(List actions, ExecutionContext executionContext, boolean isPropagated) {
        if (actions != null) {
            for (Action action : actions) {
                if (!action.acceptsPropagatedEvents() && isPropagated) continue;
                if (action.isAsync()) {
                    ExecuteActionJob job = this.createAsyncActionExecutionJob(executionContext.getToken(), action);
                    MessageService messageService = (MessageService)Services.getCurrentService("message");
                    messageService.send(job);
                    continue;
                }
                this.executeAction(action, executionContext);
            }
        }
    }

    protected ExecuteActionJob createAsyncActionExecutionJob(Token token, Action action) {
        ExecuteActionJob job = new ExecuteActionJob(token);
        job.setAction(action);
        job.setDueDate(new Date());
        job.setExclusive(action.isAsyncExclusive());
        return job;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeAction(Action action, ExecutionContext executionContext) {
        Token token = executionContext.getToken();
        ActionLog actionLog = new ActionLog(action);
        token.startCompositeLog(actionLog);
        boolean actionMustBeLocked = executionContext.getEvent() != null && !token.isLocked();
        try {
            executionContext.setAction(action);
            log.debug((Object)("executing action '" + action + "'"));
            String lockOwnerId = "token[" + token.getId() + "]";
            try {
                if (actionMustBeLocked) {
                    token.lock(lockOwnerId);
                }
                if (UserCodeInterceptorConfig.userCodeInterceptor != null) {
                    UserCodeInterceptorConfig.userCodeInterceptor.executeAction(action, executionContext);
                } else {
                    action.execute(executionContext);
                }
            }
            finally {
                if (actionMustBeLocked) {
                    token.unlock(lockOwnerId);
                }
            }
        }
        catch (Exception exception) {
            log.error((Object)("action threw exception: " + exception.getMessage()), (Throwable)exception);
            actionLog.setException(exception);
            this.raiseException(exception, executionContext);
        }
        finally {
            executionContext.setAction(null);
            token.endCompositeLog();
        }
    }

    List getRuntimeActionsForEvent(ExecutionContext executionContext, String eventType) {
        ArrayList<Action> runtimeActionsForEvent = null;
        List runtimeActions = executionContext.getProcessInstance().getRuntimeActions();
        if (runtimeActions != null) {
            for (RuntimeAction runtimeAction : runtimeActions) {
                if (!this.equals(runtimeAction.getGraphElement()) || !eventType.equals(runtimeAction.getEventType())) continue;
                if (runtimeActionsForEvent == null) {
                    runtimeActionsForEvent = new ArrayList<Action>();
                }
                runtimeActionsForEvent.add(runtimeAction.getAction());
            }
        }
        return runtimeActionsForEvent;
    }

    public void raiseException(Throwable exception, ExecutionContext executionContext) throws DelegationException {
        boolean isHandled = false;
        if (this.exceptionHandlers != null) {
            try {
                ExceptionHandler exceptionHandler = this.findExceptionHandler(exception);
                if (exceptionHandler != null) {
                    executionContext.setException(exception);
                    exceptionHandler.handleException(this, executionContext);
                    isHandled = true;
                }
            }
            catch (Exception e) {
                exception = e;
            }
        }
        if (!isHandled) {
            GraphElement parent = this.getParent();
            if (parent != null && parent != this) {
                parent.raiseException(exception, executionContext);
            } else {
                if (exception instanceof JbpmException) {
                    throw (JbpmException)exception;
                }
                throw new DelegationException(exception, executionContext);
            }
        }
    }

    protected ExceptionHandler findExceptionHandler(Throwable exception) {
        ExceptionHandler exceptionHandler = null;
        if (this.exceptionHandlers != null) {
            Iterator iter = this.exceptionHandlers.iterator();
            while (iter.hasNext() && exceptionHandler == null) {
                ExceptionHandler candidate = (ExceptionHandler)iter.next();
                if (!candidate.matches(exception)) continue;
                exceptionHandler = candidate;
            }
        }
        return exceptionHandler;
    }

    public GraphElement getParent() {
        return this.processDefinition;
    }

    public List getParents() {
        ArrayList parents = new ArrayList();
        GraphElement parent = this.getParent();
        if (parent != null) {
            parent.addParentChain(parents);
        }
        return parents;
    }

    public List getParentChain() {
        ArrayList parents = new ArrayList();
        this.addParentChain(parents);
        return parents;
    }

    void addParentChain(List parentChain) {
        parentChain.add(this);
        GraphElement parent = this.getParent();
        if (parent != null) {
            parent.addParentChain(parentChain);
        }
    }

    public String toString() {
        String className = this.getClass().getName();
        className = className.substring(className.lastIndexOf(46) + 1);
        className = this.name != null ? className + "(" + this.name + ")" : className + "(" + Integer.toHexString(System.identityHashCode(this)) + ")";
        return className;
    }

    public boolean equals(Object o) {
        return EqualsUtil.equals(this, o);
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ProcessDefinition getProcessDefinition() {
        return this.processDefinition;
    }

    public void setProcessDefinition(ProcessDefinition processDefinition) {
        this.processDefinition = processDefinition;
    }
}

