/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.mail;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmException;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.jpdl.el.ELException;
import org.jbpm.jpdl.el.VariableResolver;
import org.jbpm.jpdl.el.impl.JbpmExpressionEvaluator;
import org.jbpm.mail.AddressResolver;
import org.jbpm.mail.MailTemplates;
import org.jbpm.util.ClassLoaderUtil;

public class Mail
implements ActionHandler {
    private static final Log log = LogFactory.getLog(Mail.class);
    private String template;
    private String to;
    private String actors;
    private String cc;
    private String ccActors;
    private String bcc;
    private String bccActors;
    private String subject;
    private String text;
    private transient ExecutionContext executionContext;
    private static final long serialVersionUID = 2L;
    private static final Map serverPropertiesByResource = new HashMap();
    private static final String JBPM_MAIL_USER = "jbpm.mail.user";
    private static final String JBPM_MAIL_PASSWORD = "jbpm.mail.password";
    private static final String JBPM_MAIL_DEBUG = "jbpm.mail.debug";

    public Mail() {
    }

    public Mail(String template, String actors, String to, String subject, String text) {
        this.template = template;
        this.actors = actors;
        this.to = to;
        this.subject = subject;
        this.text = text;
    }

    public Mail(String template, String actors, String to, String bccActors, String bcc, String subject, String text) {
        this.template = template;
        this.actors = actors;
        this.to = to;
        this.bccActors = bccActors;
        this.bcc = bcc;
        this.subject = subject;
        this.text = text;
    }

    public void execute(ExecutionContext executionContext) {
        this.executionContext = executionContext;
        this.send();
    }

    public List getRecipients() {
        Collection recipientsCollection = this.collectRecipients(this.actors, this.to);
        ArrayList recipientsList = null;
        if (recipientsCollection != null) {
            recipientsList = new ArrayList(recipientsCollection);
        }
        return recipientsList;
    }

    public List getCcRecipients() {
        Collection ccRecipientsCollection = this.collectRecipients(this.ccActors, this.cc);
        ArrayList ccRecipientsList = null;
        if (ccRecipientsCollection != null) {
            ccRecipientsList = new ArrayList(ccRecipientsCollection);
        }
        return ccRecipientsList;
    }

    public List getBccRecipients() {
        ArrayList recipients = this.collectRecipients(this.bccActors, this.bcc);
        if (JbpmConfiguration.Configs.hasObject("jbpm.mail.bcc.address")) {
            if (!(recipients instanceof ArrayList)) {
                recipients = new ArrayList(recipients);
            }
            recipients.addAll(this.tokenize(JbpmConfiguration.Configs.getString("jbpm.mail.bcc.address")));
        }
        ArrayList bccRecipientsList = null;
        if (recipients != null) {
            bccRecipientsList = new ArrayList(recipients);
        }
        return bccRecipientsList;
    }

    private Collection collectRecipients(String actors, String addresses) {
        if (actors != null) {
            if (addresses != null) {
                ArrayList recipients = new ArrayList(this.evaluateActors(actors));
                recipients.addAll(this.evaluateAddresses(addresses));
                return recipients;
            }
            return this.evaluateActors(actors);
        }
        if (addresses != null) {
            return this.evaluateAddresses(addresses);
        }
        return null;
    }

    private Collection evaluateActors(String expression) {
        List<String> actorIds;
        Object value = this.evaluate(expression, Object.class);
        if (value instanceof String) {
            actorIds = this.tokenize((String)value);
        } else if (value instanceof Collection) {
            actorIds = (Collection)value;
        } else if (value instanceof String[]) {
            actorIds = Arrays.asList((String[])value);
        } else {
            throw new JbpmException(expression + " returned " + value + " instead of comma-separated string, string array or collection");
        }
        return this.resolveAddresses(actorIds);
    }

    protected Collection resolveAddresses(Collection actorIds) {
        AddressResolver addressResolver = (AddressResolver)JbpmConfiguration.Configs.getObject("jbpm.mail.address.resolver");
        ArrayList<Object> addresses = new ArrayList<Object>();
        for (String actorId : actorIds) {
            Object result = addressResolver.resolveAddress(actorId);
            if (result instanceof String) {
                addresses.add(result);
                continue;
            }
            if (result instanceof Collection) {
                addresses.addAll((Collection)result);
                continue;
            }
            if (result instanceof String[]) {
                addresses.addAll(Arrays.asList((String[])result));
                continue;
            }
            if (result == null) continue;
            throw new JbpmException(addressResolver + " returned " + result + " instead of single string, string array or collection");
        }
        return addresses;
    }

    private Collection evaluateAddresses(String expression) {
        Object value = this.evaluate(expression, Object.class);
        if (value instanceof String) {
            return this.tokenize((String)value);
        }
        if (value instanceof Collection) {
            return (Collection)value;
        }
        if (value instanceof String[]) {
            return Arrays.asList((String[])value);
        }
        throw new JbpmException(expression + " returned " + value + " instead of comma-separated string, string array or collection");
    }

    protected List tokenize(String text) {
        return text != null ? Arrays.asList(text.split("[,;:]+")) : null;
    }

    private Object evaluate(String expression, Class expectedType) {
        MailVariableResolver variableResolver = new MailVariableResolver(MailTemplates.getTemplateVariables(), JbpmExpressionEvaluator.getVariableResolver());
        return JbpmExpressionEvaluator.evaluate(expression, this.executionContext, expectedType, variableResolver, JbpmExpressionEvaluator.getFunctionMapper());
    }

    public String getSubject() {
        return this.subject != null ? (String)this.evaluate(this.subject, String.class) : null;
    }

    public String getText() {
        return this.text != null ? (String)this.evaluate(this.text, String.class) : null;
    }

    public String getFromAddress() {
        return JbpmConfiguration.Configs.hasObject("jbpm.mail.from.address") ? JbpmConfiguration.Configs.getString("jbpm.mail.from.address") : null;
    }

    public void send() {
        if (this.template != null) {
            Properties templateProperties = MailTemplates.getTemplateProperties(this.template);
            if (this.actors == null) {
                this.actors = templateProperties.getProperty("actors");
            }
            if (this.to == null) {
                this.to = templateProperties.getProperty("to");
            }
            if (this.cc == null) {
                this.cc = templateProperties.getProperty("cc");
            }
            if (this.ccActors == null) {
                this.ccActors = templateProperties.getProperty("cc-actors");
            }
            if (this.bcc == null) {
                this.bcc = templateProperties.getProperty("bcc");
            }
            if (this.bccActors == null) {
                this.bccActors = templateProperties.getProperty("bcc-actors");
            }
            if (this.subject == null) {
                this.subject = templateProperties.getProperty("subject");
            }
            if (this.text == null) {
                this.text = templateProperties.getProperty("text");
            }
        }
        MessageInfo msgInfo = new MessageInfo();
        msgInfo.sender = this.getFromAddress();
        msgInfo.recipients = this.getRecipients();
        msgInfo.ccRecipients = this.getCcRecipients();
        msgInfo.bccRecipients = this.getBccRecipients();
        if (Mail.nullOrEmpty(msgInfo.recipients) && Mail.nullOrEmpty(msgInfo.ccRecipients) && Mail.nullOrEmpty(msgInfo.bccRecipients)) {
            return;
        }
        msgInfo.subject = this.getSubject();
        msgInfo.text = this.getText();
        if (log.isDebugEnabled()) {
            StringBuffer detail = new StringBuffer("sending email");
            if (!Mail.nullOrEmpty(msgInfo.recipients)) {
                detail.append(" to ").append(msgInfo.recipients);
            }
            if (!Mail.nullOrEmpty(msgInfo.ccRecipients)) {
                detail.append(" cc ").append(msgInfo.ccRecipients);
            }
            if (!Mail.nullOrEmpty(msgInfo.bccRecipients)) {
                detail.append(" bcc ").append(msgInfo.bccRecipients);
            }
            if (this.subject != null) {
                detail.append(" about '").append(this.subject).append('\'');
            }
            log.debug((Object)detail.toString());
        }
        Properties sessionProperties = this.getServerProperties();
        msgInfo.session = Mail.getSession(sessionProperties);
        for (int retries = 4; retries >= 0; --retries) {
            try {
                Mail.sendInternal(msgInfo);
                break;
            }
            catch (MessagingException me) {
                if (retries == 0) {
                    throw new JbpmException("failed to send email", me);
                }
                log.warn((Object)("failed to send email (" + retries + " retries left): " + me.getMessage()));
                continue;
            }
        }
    }

    public static void send(Properties serverProperties, String sender, List recipients, String subject, String text) {
        Mail.send(serverProperties, sender, (Collection)recipients, subject, text);
    }

    public static void send(Properties serverProperties, String sender, Collection recipients, String subject, String text) {
        MessageInfo msgInfo = new MessageInfo(null, sender, recipients, null, null, subject, text);
        Mail.send(serverProperties, msgInfo);
    }

    public static void send(Properties serverProperties, String sender, List recipients, List bccRecipients, String subject, String text) {
        Mail.send(serverProperties, sender, (Collection)recipients, (Collection)bccRecipients, subject, text);
    }

    public static void send(Properties serverProperties, String sender, Collection recipients, Collection bccRecipients, String subject, String text) {
        MessageInfo msgInfo = new MessageInfo(null, sender, recipients, null, bccRecipients, subject, text);
        Mail.send(serverProperties, msgInfo);
    }

    private static void send(Properties serverProperties, MessageInfo msgInfo) {
        if (Mail.nullOrEmpty(msgInfo.recipients) && Mail.nullOrEmpty(msgInfo.bccRecipients)) {
            return;
        }
        if (log.isDebugEnabled()) {
            StringBuffer detail = new StringBuffer("sending email to ");
            detail.append(msgInfo.recipients);
            if (msgInfo.bccRecipients != null) {
                detail.append(" bcc ").append(msgInfo.bccRecipients);
            }
            if (msgInfo.subject != null) {
                detail.append(" about '").append(msgInfo.subject).append('\'');
            }
            log.debug((Object)detail.toString());
        }
        msgInfo.session = Mail.getSession(serverProperties);
        for (int retries = 4; retries >= 0; --retries) {
            try {
                Mail.sendInternal(msgInfo);
                break;
            }
            catch (MessagingException me) {
                if (retries == 0) {
                    throw new JbpmException("failed to send email", me);
                }
                log.warn((Object)("failed to send email (" + retries + " retries left): " + me.getMessage()));
                continue;
            }
        }
    }

    private static boolean nullOrEmpty(Collection col) {
        return col == null || col.isEmpty();
    }

    private static void sendInternal(MessageInfo msgInfo) throws MessagingException {
        Message message = Mail.fillMessage(msgInfo);
        Transport.send((Message)message);
    }

    private static Message fillMessage(MessageInfo msgInfo) throws MessagingException {
        InternetAddress recipient;
        Iterator iter;
        MimeMessage message = new MimeMessage(msgInfo.session);
        if (msgInfo.sender != null) {
            message.setFrom((Address)new InternetAddress(msgInfo.sender));
        } else {
            message.setFrom();
        }
        if (msgInfo.recipients != null) {
            iter = msgInfo.recipients.iterator();
            while (iter.hasNext()) {
                recipient = new InternetAddress((String)iter.next());
                message.addRecipient(Message.RecipientType.TO, (Address)recipient);
            }
        }
        if (msgInfo.ccRecipients != null) {
            iter = msgInfo.ccRecipients.iterator();
            while (iter.hasNext()) {
                recipient = new InternetAddress((String)iter.next());
                message.addRecipient(Message.RecipientType.CC, (Address)recipient);
            }
        }
        if (msgInfo.bccRecipients != null) {
            iter = msgInfo.bccRecipients.iterator();
            while (iter.hasNext()) {
                recipient = new InternetAddress((String)iter.next());
                message.addRecipient(Message.RecipientType.BCC, (Address)recipient);
            }
        }
        if (msgInfo.subject != null) {
            message.setSubject(msgInfo.subject);
        }
        if (msgInfo.text != null) {
            message.setText(msgInfo.text);
        }
        return message;
    }

    private static Session getSession(Properties properties) {
        Session session;
        String userName = (String)properties.remove(JBPM_MAIL_USER);
        String password = (String)properties.remove(JBPM_MAIL_PASSWORD);
        if (userName != null) {
            properties.setProperty("mail.smtp.submitter", userName);
            Authenticator authenticator = new Authenticator(userName, password);
            session = Session.getInstance((Properties)properties, (javax.mail.Authenticator)authenticator);
            if (password != null) {
                properties.setProperty("mail.smtp.auth", "true");
            }
        } else {
            properties.remove("mail.smtp.auth");
            properties.remove("mail.smtp.starttls.enable");
            session = Session.getInstance((Properties)properties);
        }
        String debugStr = (String)properties.remove(JBPM_MAIL_DEBUG);
        boolean debug = false;
        if (debugStr != null) {
            debug = Boolean.getBoolean(debugStr);
        }
        session.setDebug(debug);
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getServerProperties() {
        Properties serverProperties;
        if (JbpmConfiguration.Configs.hasObject("resource.mail.properties")) {
            String resource = JbpmConfiguration.Configs.getString("resource.mail.properties");
            Map map = serverPropertiesByResource;
            synchronized (map) {
                serverProperties = (Properties)serverPropertiesByResource.get(resource);
                if (serverProperties == null) {
                    serverProperties = ClassLoaderUtil.getProperties(resource);
                    serverPropertiesByResource.put(resource, serverProperties);
                }
            }
        } else {
            serverProperties = new Properties();
            String jbpmProperty = "jbpm.mail.smtp.host";
            if (JbpmConfiguration.Configs.hasObject(jbpmProperty)) {
                String smtpHost = JbpmConfiguration.Configs.getString(jbpmProperty);
                serverProperties.setProperty("mail.smtp.host", smtpHost);
            }
            if (JbpmConfiguration.Configs.hasObject(jbpmProperty = "jbpm.mail.smtp.port")) {
                int port = JbpmConfiguration.Configs.getInt(jbpmProperty);
                serverProperties.setProperty("mail.smtp.port", Integer.toString(port));
            }
            if (JbpmConfiguration.Configs.hasObject(jbpmProperty = "jbpm.mail.smtp.starttls")) {
                boolean enableTLS = JbpmConfiguration.Configs.getBoolean(jbpmProperty);
                serverProperties.setProperty("mail.smtp.starttls.enable", Boolean.toString(enableTLS));
            }
            if (JbpmConfiguration.Configs.hasObject(jbpmProperty = "jbpm.mail.smtp.auth")) {
                boolean useAuth = JbpmConfiguration.Configs.getBoolean(jbpmProperty);
                serverProperties.setProperty("mail.smtp.auth", Boolean.toString(useAuth));
            }
            String[] propNameStrings = new String[]{JBPM_MAIL_USER, JBPM_MAIL_PASSWORD};
            for (int i = 0; i < propNameStrings.length; ++i) {
                if (!JbpmConfiguration.Configs.hasObject(propNameStrings[i])) continue;
                String propVal = JbpmConfiguration.Configs.getString(propNameStrings[i]);
                serverProperties.setProperty(propNameStrings[i], propVal);
            }
            jbpmProperty = JBPM_MAIL_DEBUG;
            if (JbpmConfiguration.Configs.hasObject(jbpmProperty)) {
                boolean debug = JbpmConfiguration.Configs.getBoolean(jbpmProperty);
                serverProperties.setProperty(JBPM_MAIL_DEBUG, Boolean.toString(debug));
            }
        }
        return serverProperties;
    }

    private static class MessageInfo
    implements Serializable {
        private static final long serialVersionUID = -4252493407344235335L;
        public transient Session session;
        public String sender;
        public Collection recipients;
        public Collection ccRecipients;
        public Collection bccRecipients;
        public String subject;
        public String text;

        public MessageInfo() {
        }

        public MessageInfo(Session session, String sender, Collection recipients, Collection ccRecipients, Collection bccRecipients, String subject, String text) {
            this.session = session;
            this.sender = sender;
            this.recipients = recipients;
            this.ccRecipients = ccRecipients;
            this.bccRecipients = bccRecipients;
            this.subject = subject;
            this.text = text;
        }
    }

    static class MailVariableResolver
    implements VariableResolver,
    Serializable {
        private Map templateVariables;
        private VariableResolver variableResolver;
        private static final long serialVersionUID = 1L;

        MailVariableResolver(Map templateVariables, VariableResolver variableResolver) {
            this.templateVariables = templateVariables;
            this.variableResolver = variableResolver;
        }

        public Object resolveVariable(String pName) throws ELException {
            if (this.templateVariables != null && this.templateVariables.containsKey(pName)) {
                return this.templateVariables.get(pName);
            }
            return this.variableResolver != null ? this.variableResolver.resolveVariable(pName) : null;
        }
    }

    private static class Authenticator
    extends javax.mail.Authenticator
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private transient PasswordAuthentication authentication;

        public Authenticator(String username, String password) {
            this.authentication = new PasswordAuthentication(username, password);
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            return this.authentication;
        }
    }
}

