/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.job.executor;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.db.JobSession;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.job.Job;
import org.jbpm.job.executor.Deactivable;
import org.jbpm.job.executor.JobExecutor;
import org.jbpm.persistence.db.DbPersistenceService;
import org.jbpm.persistence.db.StaleObjectLogConfigurer;

public class JobExecutorThread
extends Thread
implements Deactivable {
    private final JobExecutor jobExecutor;
    private volatile boolean active = true;
    private Random random = new Random();
    private static final Log log = LogFactory.getLog(JobExecutorThread.class);

    public JobExecutorThread(String name, JobExecutor jobExecutor) {
        super(jobExecutor.getThreadGroup(), name);
        this.jobExecutor = jobExecutor;
    }

    public void run() {
        while (this.active) {
            Job job = this.jobExecutor.getJob();
            if (job == null) continue;
            try {
                this.executeJob(job);
            }
            catch (Exception e) {
                this.saveJobException(job, e);
            }
            catch (Error e) {
                this.unlockJob(job);
                throw e;
            }
        }
        log.info((Object)(this.getName() + " leaves cyberspace"));
    }

    protected void executeJob(Job job) throws Exception {
        JbpmContext jbpmContext = this.jobExecutor.getJbpmConfiguration().createJbpmContext();
        try {
            JobSession jobSession = jbpmContext.getJobSession();
            jobSession.reattachJob(job);
            ProcessInstance processInstance = job.getProcessInstance();
            jbpmContext.addAutoSaveProcessInstance(processInstance);
            if (job.isExclusive()) {
                jbpmContext.getGraphSession().lockProcessInstance(processInstance);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("executing " + job));
            }
            if (job.execute(jbpmContext)) {
                jobSession.deleteJob(job);
            }
        }
        catch (Exception e) {
            jbpmContext.setRollbackOnly();
            throw e;
        }
        catch (Error e) {
            jbpmContext.setRollbackOnly();
            throw e;
        }
        finally {
            jbpmContext.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveJobException(Job job, Exception exception) {
        if (DbPersistenceService.isLockingException(exception)) {
            StaleObjectLogConfigurer.getStaleObjectExceptionsLog().error((Object)("failed to execute " + job), (Throwable)exception);
        } else {
            log.error((Object)("failed to execute " + job), (Throwable)exception);
        }
        JbpmContext jbpmContext = this.jobExecutor.getJbpmConfiguration().createJbpmContext();
        try {
            jbpmContext.getSession().refresh((Object)job);
            StringWriter out = new StringWriter();
            exception.printStackTrace(new PrintWriter(out));
            job.setException(out.toString());
            job.setLockOwner(null);
            job.setLockTime(null);
            int waitPeriod = this.jobExecutor.getRetryInterval() / 2;
            waitPeriod += this.random.nextInt(waitPeriod);
            job.setDueDate(new Date(System.currentTimeMillis() + (long)waitPeriod));
        }
        catch (RuntimeException e) {
            jbpmContext.setRollbackOnly();
            log.warn((Object)("failed to save exception for " + job), (Throwable)e);
        }
        catch (Error e) {
            jbpmContext.setRollbackOnly();
            throw e;
        }
        finally {
            try {
                jbpmContext.close();
            }
            catch (RuntimeException e) {
                log.warn((Object)("failed to save exception for " + job), (Throwable)e);
            }
        }
        JobExecutor jobExecutor = this.jobExecutor;
        synchronized (jobExecutor) {
            this.jobExecutor.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlockJob(Job job) {
        JbpmContext jbpmContext = this.jobExecutor.getJbpmConfiguration().createJbpmContext();
        try {
            jbpmContext.getSession().refresh((Object)job);
            job.setLockOwner(null);
            job.setLockTime(null);
            if (job.getException() != null) {
                job.setRetries(job.getRetries() + 1);
            }
        }
        catch (RuntimeException e) {
            jbpmContext.setRollbackOnly();
            log.warn((Object)("failed to unlock " + job), (Throwable)e);
        }
        catch (Error e) {
            jbpmContext.setRollbackOnly();
            log.warn((Object)("failed to unlock " + job), (Throwable)e);
        }
        finally {
            try {
                jbpmContext.close();
            }
            catch (RuntimeException e) {
                log.warn((Object)("failed to unlock " + job), (Throwable)e);
            }
        }
        JobExecutor jobExecutor = this.jobExecutor;
        synchronized (jobExecutor) {
            this.jobExecutor.notify();
        }
    }

    public void deactivate() {
        if (this.active) {
            this.active = false;
            this.interrupt();
        }
    }

    public JobExecutorThread(String name, JobExecutor jobExecutor, JbpmConfiguration jbpmConfiguration, int idleInterval, int maxIdleInterval, long maxLockTime, int maxHistory) {
        super(jobExecutor.getThreadGroup(), name);
        this.jobExecutor = jobExecutor;
    }

    public void setActive(boolean isActive) {
        if (!isActive) {
            this.deactivate();
        }
    }
}

