/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.db;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.connection.ConnectionProviderFactory;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.Mapping;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Table;
import org.hibernate.tool.hbm2ddl.ColumnMetadata;
import org.hibernate.tool.hbm2ddl.DatabaseMetadata;
import org.hibernate.tool.hbm2ddl.TableMetadata;
import org.hibernate.util.JDBCExceptionReporter;
import org.jbpm.JbpmException;
import org.jbpm.util.IoUtil;

public class JbpmSchema {
    private final Configuration configuration;
    private ConnectionProvider connectionProvider;
    private String delimiter;
    private final List exceptions = new ArrayList();
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String[] TABLE_TYPES = new String[]{"TABLE"};

    public JbpmSchema(Configuration configuration) {
        this.configuration = configuration;
    }

    private Dialect getDialect() {
        return Dialect.getDialect((Properties)this.configuration.getProperties());
    }

    private String getDefaultCatalog() {
        return this.configuration.getProperty("hibernate.default_catalog");
    }

    private String getDefaultSchema() {
        return this.configuration.getProperty("hibernate.default_schema");
    }

    private boolean getShowSql() {
        return "true".equalsIgnoreCase(this.configuration.getProperty("hibernate.show_sql"));
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public List getExceptions() {
        return this.exceptions;
    }

    public String[] getCreateSql() {
        return this.configuration.generateSchemaCreationScript(this.getDialect());
    }

    public String[] getDropSql() {
        return this.configuration.generateDropSchemaScript(this.getDialect());
    }

    public String[] getCleanSql() {
        return JbpmSchema.concat(this.getDropSql(), this.getCreateSql());
    }

    private static String[] concat(String[] array1, String[] array2) {
        int length1 = array1.length;
        int length2 = array2.length;
        String[] result = new String[length1 + length2];
        System.arraycopy(array1, 0, result, 0, length1);
        System.arraycopy(array2, 0, result, length1, length2);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getUpdateSql() {
        Connection connection = null;
        try {
            connection = this.createConnection();
            String[] stringArray = this.configuration.generateSchemaUpdateScript(this.getDialect(), this.getDatabaseMetadata(connection));
            return stringArray;
        }
        catch (SQLException e) {
            this.exceptions.add(e);
            JDBCExceptionReporter.logExceptions((SQLException)e, (String)"failed to generate update sql");
            String[] stringArray = EMPTY_STRING_ARRAY;
            return stringArray;
        }
        finally {
            this.closeConnection(connection);
        }
    }

    public void dropSchema() {
        try {
            this.execute(this.getDropSql());
        }
        catch (SQLException e) {
            this.exceptions.add(e);
            JDBCExceptionReporter.logExceptions((SQLException)e, (String)"failed to drop schema");
        }
    }

    public void createSchema() {
        try {
            this.execute(this.getCreateSql());
        }
        catch (SQLException e) {
            this.exceptions.add(e);
            JDBCExceptionReporter.logExceptions((SQLException)e, (String)"failed to create schema");
        }
    }

    public void cleanSchema() {
        try {
            this.execute(this.getCleanSql());
        }
        catch (SQLException e) {
            this.exceptions.add(e);
            JDBCExceptionReporter.logExceptions((SQLException)e, (String)"failed to clean schema");
        }
    }

    public void updateSchema() {
        try {
            this.execute(this.getUpdateSql());
        }
        catch (SQLException e) {
            this.exceptions.add(e);
            JDBCExceptionReporter.logExceptions((SQLException)e, (String)"failed to update schema");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(String[] script) throws SQLException {
        Connection connection = null;
        try {
            connection = this.createConnection();
            Statement statement = connection.createStatement();
            try {
                boolean showSql = this.getShowSql();
                for (int i = 0; i < script.length; ++i) {
                    String sql = script[i];
                    if (showSql) {
                        System.out.println(sql);
                    }
                    this.execute(sql, statement);
                }
            }
            finally {
                statement.close();
            }
        }
        finally {
            this.closeConnection(connection);
        }
    }

    private void execute(String sql, Statement statement) {
        try {
            statement.executeUpdate(sql);
            SQLWarning warning = statement.getWarnings();
            if (warning != null) {
                JDBCExceptionReporter.logWarnings((SQLWarning)warning);
                statement.clearWarnings();
            }
        }
        catch (SQLException e) {
            JDBCExceptionReporter.logExceptions((SQLException)e, (String)"failed to execute update");
            this.exceptions.add(e);
        }
    }

    public void saveSqlScripts(String dir, String prefix) {
        File path = new File(dir);
        if (!path.isDirectory()) {
            throw new JbpmException(path + " is not a directory");
        }
        try {
            this.saveSqlScript(new File(path, prefix + ".drop.sql"), this.getDropSql());
            this.saveSqlScript(new File(path, prefix + ".create.sql"), this.getCreateSql());
            this.saveSqlScript(new File(path, prefix + ".clean.sql"), this.getCleanSql());
        }
        catch (IOException e) {
            throw new JbpmException("failed to generate scripts", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveSqlScript(File file, String[] script) throws IOException {
        FileWriter writer = new FileWriter(file);
        try {
            this.writeSql(writer, script);
        }
        finally {
            ((Writer)writer).close();
        }
    }

    public void writeSql(Writer writer, String[] script) throws IOException {
        for (int i = 0; i < script.length; ++i) {
            writer.write(script[i]);
            if (this.delimiter != null) {
                writer.write(this.delimiter);
            }
            writer.write(IoUtil.lineSeparator);
        }
    }

    public Set getJbpmTables() {
        HashSet<String> jbpmTables = new HashSet<String>();
        Iterator i = this.configuration.getTableMappings();
        while (i.hasNext()) {
            Table table = (Table)i.next();
            if (!table.isPhysicalTable()) continue;
            jbpmTables.add(table.getName());
        }
        return jbpmTables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getRowsPerTable() {
        Connection connection = null;
        try {
            connection = this.createConnection();
            HashMap<String, Long> rowsPerTable = new HashMap<String, Long>();
            Statement statement = connection.createStatement();
            try {
                for (String tableName : this.getJbpmTables()) {
                    String sql = "SELECT COUNT(*) FROM " + tableName;
                    ResultSet resultSet = statement.executeQuery(sql);
                    if (!resultSet.next()) continue;
                    long count = resultSet.getLong(1);
                    if (resultSet.wasNull()) continue;
                    rowsPerTable.put(tableName, new Long(count));
                    resultSet.close();
                }
            }
            finally {
                statement.close();
            }
            HashMap<String, Long> hashMap = rowsPerTable;
            return hashMap;
        }
        catch (SQLException e) {
            this.exceptions.add(e);
            JDBCExceptionReporter.logExceptions((SQLException)e, (String)"could not count records");
            Map map = Collections.EMPTY_MAP;
            return map;
        }
        finally {
            this.closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getExistingTables() {
        Connection connection = null;
        try {
            connection = this.createConnection();
            HashSet<String> existingTables = new HashSet<String>();
            DatabaseMetaData metaData = connection.getMetaData();
            boolean storesLowerCaseIdentifiers = metaData.storesLowerCaseIdentifiers();
            ResultSet resultSet = metaData.getTables(this.getDefaultCatalog(), this.getDefaultSchema(), null, TABLE_TYPES);
            try {
                while (resultSet.next()) {
                    String tableName = resultSet.getString("TABLE_NAME");
                    if (storesLowerCaseIdentifiers) {
                        tableName = tableName.toUpperCase();
                    }
                    existingTables.add(tableName);
                }
            }
            finally {
                resultSet.close();
            }
            HashSet<String> hashSet = existingTables;
            return hashSet;
        }
        catch (SQLException e) {
            this.exceptions.add(e);
            JDBCExceptionReporter.logExceptions((SQLException)e, (String)"could not get available table names");
            Set set = Collections.EMPTY_SET;
            return set;
        }
        finally {
            this.closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tableExists(String tableName) {
        Connection connection = null;
        try {
            boolean bl;
            connection = this.createConnection();
            DatabaseMetaData metaData = connection.getMetaData();
            ResultSet resultSet = metaData.getTables(this.getDefaultCatalog(), this.getDefaultSchema(), tableName, TABLE_TYPES);
            try {
                bl = resultSet.next();
            }
            catch (Throwable throwable) {
                try {
                    resultSet.close();
                    throw throwable;
                }
                catch (SQLException e) {
                    this.exceptions.add(e);
                    JDBCExceptionReporter.logExceptions((SQLException)e, (String)"could not determine whether table exists");
                    boolean bl2 = false;
                    return bl2;
                }
            }
            resultSet.close();
            return bl;
        }
        finally {
            this.closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTable(String tableName) {
        Table table = this.findTableMapping(tableName);
        Connection connection = null;
        try {
            connection = this.createConnection();
            TableMetadata tableInfo = this.getTableMetadata(connection, table);
            Statement statement = connection.createStatement();
            try {
                if (tableInfo != null) {
                    Iterator script = this.sqlAlterStrings(table, tableInfo);
                    while (script.hasNext()) {
                        String sql = (String)script.next();
                        this.execute(sql, statement);
                    }
                } else {
                    this.execute(this.sqlCreateString(table), statement);
                }
            }
            finally {
                statement.close();
            }
        }
        catch (SQLException e) {
            this.exceptions.add(e);
            JDBCExceptionReporter.logExceptions((SQLException)e, (String)"failed to update table");
        }
        finally {
            this.closeConnection(connection);
        }
    }

    private Table findTableMapping(String tableName) {
        Iterator i = this.configuration.getTableMappings();
        while (i.hasNext()) {
            Table table = (Table)i.next();
            if (!tableName.equals(table.getName())) continue;
            return table;
        }
        throw new JbpmException("no mapping found for table: " + tableName);
    }

    private TableMetadata getTableMetadata(Connection connection, Table table) throws SQLException {
        String tableCatalog;
        String tableSchema = table.getSchema();
        if (tableSchema == null) {
            tableSchema = this.getDefaultSchema();
        }
        if ((tableCatalog = table.getCatalog()) == null) {
            tableCatalog = this.getDefaultCatalog();
        }
        return this.getDatabaseMetadata(connection).getTableMetadata(table.getName(), tableSchema, tableCatalog, table.isQuoted());
    }

    private DatabaseMetadata getDatabaseMetadata(Connection connection) throws SQLException {
        return new DatabaseMetadata(connection, this.getDialect());
    }

    private Iterator sqlAlterStrings(Table table, TableMetadata tableMetadata) throws SQLException {
        Dialect dialect = this.getDialect();
        Mapping mapping = this.configuration.buildMapping();
        StringBuffer root = new StringBuffer("alter table ").append(table.getQualifiedName(dialect, this.getDefaultCatalog(), this.getDefaultSchema())).append(' ').append(dialect.getAddColumnString());
        int rootLength = root.length();
        ArrayList<String> results = new ArrayList<String>();
        Iterator iter = table.getColumnIterator();
        while (iter.hasNext()) {
            String columnComment;
            boolean useUniqueConstraint;
            Column column = (Column)iter.next();
            ColumnMetadata columnInfo = tableMetadata.getColumnMetadata(column.getName());
            if (columnInfo != null) continue;
            root.setLength(rootLength);
            StringBuffer alter = root.append(' ').append(column.getQuotedName(dialect)).append(' ').append(column.getSqlType(dialect, mapping));
            String defaultValue = column.getDefaultValue();
            if (defaultValue != null) {
                alter.append(" default ").append(defaultValue);
            }
            if (column.isNullable()) {
                alter.append(dialect.getNullColumnString());
            } else {
                alter.append(" not null");
            }
            boolean bl = useUniqueConstraint = column.isUnique() && dialect.supportsUnique() && (!column.isNullable() || dialect.supportsNotNullUnique());
            if (useUniqueConstraint) {
                alter.append(" unique");
            }
            if (column.hasCheckConstraint() && dialect.supportsColumnCheck()) {
                alter.append(" check(").append(column.getCheckConstraint()).append(")");
            }
            if ((columnComment = column.getComment()) != null) {
                alter.append(dialect.getColumnComment(columnComment));
            }
            results.add(alter.toString());
        }
        return results.iterator();
    }

    public void createTable(String tableName) {
        Table table = this.findTableMapping(tableName);
        String sql = this.sqlCreateString(table);
        try {
            this.execute(new String[]{sql});
        }
        catch (SQLException e) {
            this.exceptions.add(e);
            JDBCExceptionReporter.logExceptions((SQLException)e, (String)"failed to create table");
        }
    }

    private String sqlCreateString(Table table) {
        return table.sqlCreateString(this.getDialect(), this.configuration.buildMapping(), this.getDefaultCatalog(), this.getDefaultSchema());
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            String action = args[0];
            if ("create".equalsIgnoreCase(action)) {
                JbpmSchema.getJbpmSchema(args, 1).createSchema();
            } else if ("drop".equalsIgnoreCase(action)) {
                JbpmSchema.getJbpmSchema(args, 1).dropSchema();
            } else if ("clean".equalsIgnoreCase(action)) {
                JbpmSchema.getJbpmSchema(args, 1).cleanSchema();
            } else if ("update".equalsIgnoreCase(action)) {
                JbpmSchema.getJbpmSchema(args, 1).updateSchema();
            } else if ("scripts".equalsIgnoreCase(action) && args.length > 2) {
                JbpmSchema.getJbpmSchema(args, 3).saveSqlScripts(args[1], args[2]);
            } else {
                JbpmSchema.syntax();
            }
        } else {
            JbpmSchema.syntax();
        }
    }

    private static void syntax() {
        System.err.println("Syntax:");
        System.err.println("JbpmSchema create [<hibernate.cfg.xml> [<hibernate.properties>]]");
        System.err.println("JbpmSchema drop [<hibernate.cfg.xml> [<hibernate.properties>]]");
        System.err.println("JbpmSchema clean [<hibernate.cfg.xml> [<hibernate.properties>]]");
        System.err.println("JbpmSchema update [<hibernate.cfg.xml> [<hibernate.properties>]]");
        System.err.println("JbpmSchema scripts <dir> <prefix> [<hibernate.cfg.xml> [<hibernate.properties>]]");
        System.exit(1);
    }

    private static JbpmSchema getJbpmSchema(String[] args, int index) {
        Configuration configuration = new Configuration();
        if (index < args.length) {
            String hibernateCfgXml = args[index];
            configuration.configure(new File(hibernateCfgXml));
            if (index + 1 < args.length) {
                String hibernateProperties = args[index + 1];
                try {
                    FileInputStream fileSource = new FileInputStream(hibernateProperties);
                    Properties properties = new Properties();
                    properties.load(fileSource);
                    ((InputStream)fileSource).close();
                    configuration.addProperties(properties);
                }
                catch (IOException e) {
                    throw new JbpmException("failed to load hibernate properties", e);
                }
            }
        } else {
            configuration.configure();
        }
        return new JbpmSchema(configuration);
    }

    private Connection createConnection() throws SQLException {
        try {
            this.connectionProvider = ConnectionProviderFactory.newConnectionProvider((Properties)this.configuration.getProperties());
        }
        catch (HibernateException e) {
            throw new SQLException(e.getMessage());
        }
        Connection connection = this.connectionProvider.getConnection();
        if (!connection.getAutoCommit()) {
            connection.commit();
            connection.setAutoCommit(true);
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConnection(Connection connection) {
        if (this.connectionProvider != null) {
            try {
                if (connection != null) {
                    JDBCExceptionReporter.logAndClearWarnings((Connection)connection);
                    this.connectionProvider.closeConnection(connection);
                }
            }
            catch (SQLException e) {
                this.exceptions.add(e);
                JDBCExceptionReporter.logExceptions((SQLException)e);
            }
            finally {
                this.connectionProvider.close();
                this.connectionProvider = null;
            }
        }
    }
}

