/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.command;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmContext;
import org.jbpm.command.AbstractBaseCommand;
import org.jbpm.command.GetProcessInstancesCommand;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.util.ArrayUtil;

public abstract class AbstractProcessInstanceBaseCommand
extends AbstractBaseCommand {
    protected final Log log = LogFactory.getLog(this.getClass());
    private long[] processInstanceIds;
    private String processName;
    private int processVersion;
    private boolean onlyRunning = true;
    private boolean operateOnSingleObject;
    private transient JbpmContext jbpmContext;
    private static final long serialVersionUID = 1L;

    protected JbpmContext getJbpmContext() {
        return this.jbpmContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(JbpmContext jbpmContext) throws Exception {
        ArrayList<ProcessInstance> result = new ArrayList<ProcessInstance>();
        this.jbpmContext = jbpmContext;
        try {
            if (this.processInstanceIds != null && this.processInstanceIds.length > 0) {
                for (int i = 0; i < this.processInstanceIds.length; ++i) {
                    ProcessInstance pi = jbpmContext.loadProcessInstanceForUpdate(this.processInstanceIds[i]);
                    result.add(this.execute(pi));
                }
            }
            if (this.processName != null) {
                this.operateOnSingleObject = false;
                GetProcessInstancesCommand cmd = new GetProcessInstancesCommand();
                cmd.setProcessDefinitionName(this.processName);
                cmd.setOnlyRunning(this.onlyRunning);
                if (this.processVersion > 0) {
                    cmd.setVersion(String.valueOf(this.processVersion));
                }
                List processInstanceList = (List)cmd.execute(jbpmContext);
                for (ProcessInstance pi : processInstanceList) {
                    this.execute(pi);
                }
            }
            if (this.operateOnSingleObject) {
                Object var3_5 = result.isEmpty() ? null : result.get(0);
                return var3_5;
            }
            ArrayList<ProcessInstance> arrayList = result;
            return arrayList;
        }
        finally {
            jbpmContext = null;
        }
    }

    public abstract ProcessInstance execute(ProcessInstance var1);

    public void setProcessInstanceIds(long[] processInstanceIds) {
        this.operateOnSingleObject = false;
        this.processInstanceIds = processInstanceIds;
    }

    public void setProcessInstanceId(long processInstanceId) {
        this.operateOnSingleObject = true;
        this.processInstanceIds = new long[1];
        this.processInstanceIds[0] = processInstanceId;
    }

    public String toString() {
        if (this.processName != null) {
            return this.getClass().getName() + " [tokenIds=" + ArrayUtil.toString(this.processInstanceIds) + ";processName=" + this.processName + ";processVersion=" + (this.processVersion > 0 ? Integer.toString(this.processVersion) : "NA") + this.getAdditionalToStringInformation() + "]";
        }
        return this.getClass().getName() + " [tokenIds=" + ArrayUtil.toString(this.processInstanceIds) + ";operateOnSingleObject=" + this.operateOnSingleObject + this.getAdditionalToStringInformation() + "]";
    }

    public String getProcessName() {
        return this.processName;
    }

    public void setProcessName(String processName) {
        this.processName = processName;
    }

    public int getProcessVersion() {
        return this.processVersion;
    }

    public void setProcessVersion(int processVersion) {
        this.processVersion = processVersion;
    }

    public long[] getProcessInstanceIds() {
        return this.processInstanceIds;
    }

    public long getProcessInstanceId() {
        if (this.processInstanceIds == null || this.processInstanceIds.length > 1) {
            throw new IllegalStateException("multiple process instance ids set: " + ArrayUtil.toString(this.processInstanceIds));
        }
        return this.processInstanceIds[0];
    }

    public boolean isOnlyRunning() {
        return this.onlyRunning;
    }

    public void setOnlyRunning(boolean onlyRunning) {
        this.onlyRunning = onlyRunning;
    }

    public AbstractProcessInstanceBaseCommand processInstanceIds(long[] processInstanceIds) {
        this.setProcessInstanceIds(processInstanceIds);
        return this;
    }

    public AbstractProcessInstanceBaseCommand processInstanceId(long processInstanceId) {
        this.setProcessInstanceId(processInstanceId);
        return this;
    }

    public AbstractProcessInstanceBaseCommand processName(String processName) {
        this.setProcessName(processName);
        return this;
    }

    public AbstractProcessInstanceBaseCommand processVersion(int processVersion) {
        this.setProcessVersion(processVersion);
        return this;
    }

    public AbstractProcessInstanceBaseCommand onlyRunning(boolean onlyRunning) {
        this.setOnlyRunning(onlyRunning);
        return this;
    }
}

