/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.command;

import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmContext;
import org.jbpm.command.AbstractBaseCommand;
import org.jbpm.graph.exe.Token;
import org.jbpm.taskmgmt.exe.TaskInstance;

public abstract class AbstractCancelCommand
extends AbstractBaseCommand {
    private static final long serialVersionUID = 1L;
    public static final String CANCELLATION_INDICATOR_VARIABLE_NAME = "canceled";
    protected transient JbpmContext jbpmContext;
    protected static final Log log = LogFactory.getLog(AbstractCancelCommand.class);

    protected void cancelTokens(Collection tokens) {
        if (tokens != null && !tokens.isEmpty()) {
            boolean debug = log.isDebugEnabled();
            if (debug) {
                log.debug((Object)("cancelling " + tokens.size() + " tokens"));
            }
            for (Token token : tokens) {
                if (debug) {
                    log.debug((Object)("cancelling " + token));
                }
                this.cancelToken(token);
            }
        }
    }

    protected void cancelToken(Token token) {
        this.cancelTokens(token.getChildren().values());
        this.cancelTasks(this.getTasksForToken(token));
        if (!token.hasEnded()) {
            token.end(false);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("cancelled " + token));
        }
    }

    protected List getTasksForToken(Token token) {
        return this.jbpmContext.getSession().getNamedQuery("TaskMgmtSession.findTaskInstancesByTokenId").setLong("tokenId", token.getId()).list();
    }

    protected void cancelTasks(List tasks) {
        if (tasks != null && !tasks.isEmpty()) {
            boolean debug = log.isDebugEnabled();
            if (debug) {
                log.debug((Object)("cancelling " + tasks.size() + " tasks"));
            }
            for (TaskInstance ti : tasks) {
                if (debug) {
                    log.debug((Object)("cancelling " + ti));
                }
                ti.setSignalling(false);
                ti.cancel();
            }
        }
    }
}

