/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.calendar;

import java.io.Serializable;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.jbpm.calendar.BusinessCalendar;

public class Duration
implements Serializable {
    private static final long serialVersionUID = 2L;
    static final long SECOND = 1000L;
    static final long MINUTE = 60000L;
    static final long HOUR = 3600000L;
    static final long DAY = 86400000L;
    static final long WEEK = 604800000L;
    static final long BUSINESS_DAY;
    static final long BUSINESS_WEEK;
    static final long BUSINESS_MONTH;
    static final long BUSINESS_YEAR;
    static Map calendarFields;
    static Map businessAmounts;
    private int field;
    private long amount;
    private boolean isBusinessTime;

    private static long multiply(Number n1, long n2) {
        return n1 instanceof Long ? n1.longValue() * n2 : (long)(n1.doubleValue() * (double)n2);
    }

    Duration() {
    }

    public Duration(long milliseconds) {
        this.amount = milliseconds;
        this.field = 14;
    }

    public Duration(Duration duration) {
        this.field = duration.field;
        this.amount = duration.amount;
        this.isBusinessTime = duration.isBusinessTime;
    }

    public Duration(String duration) {
        ParsePosition position;
        NumberFormat format;
        Number quantity;
        int index = Duration.indexOfNonWhite(duration, 0);
        char lead = duration.charAt(index);
        if (lead == '+' || lead == '-') {
            ++index;
        }
        if ((quantity = (format = NumberFormat.getNumberInstance(Locale.US)).parse(duration, position = new ParsePosition(index = Duration.indexOfNonWhite(duration, index)))) == null) {
            throw new IllegalArgumentException("failed to parse amount: " + duration);
        }
        String unitText = duration.substring(position.getIndex()).trim();
        if (unitText.startsWith("business")) {
            Long unit = (Long)businessAmounts.get(unitText);
            if (unit == null) {
                throw new IllegalArgumentException("no such time unit: " + unitText);
            }
            this.field = 14;
            this.amount = Duration.multiply(quantity, unit);
            this.isBusinessTime = true;
        } else {
            Integer unit = (Integer)calendarFields.get(unitText);
            if (unit == null) {
                throw new IllegalArgumentException("no such time unit: " + unitText);
            }
            if (quantity instanceof Long && Duration.isInteger(quantity.longValue())) {
                this.field = unit;
                this.amount = quantity.longValue();
            } else {
                this.field = 14;
                switch (unit) {
                    case 13: {
                        this.amount = (long)(quantity.doubleValue() * 1000.0);
                        break;
                    }
                    case 12: {
                        this.amount = (long)(quantity.doubleValue() * 60000.0);
                        break;
                    }
                    case 10: {
                        this.amount = (long)(quantity.doubleValue() * 3600000.0);
                        break;
                    }
                    case 5: {
                        this.amount = (long)(quantity.doubleValue() * 8.64E7);
                        break;
                    }
                    case 4: {
                        this.amount = (long)(quantity.doubleValue() * 6.048E8);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("fractional amount not supported for time unit: " + unitText);
                    }
                }
            }
        }
        if (lead == '-') {
            this.amount = -this.amount;
        }
    }

    boolean isNegative() {
        return this.amount < 0L;
    }

    static int indexOfNonWhite(String str, int fromIndex) {
        int len = str.length();
        for (int off = fromIndex; off < len; ++off) {
            if (str.charAt(off) == ' ') continue;
            return off;
        }
        return -1;
    }

    private static boolean isInteger(long number) {
        return number >= Integer.MIN_VALUE && number <= Integer.MAX_VALUE;
    }

    public Date addTo(Date date) {
        if (this.field == 14) {
            return new Date(date.getTime() + this.amount);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(this.field, (int)this.amount);
        return calendar.getTime();
    }

    public long getMilliseconds() {
        switch (this.field) {
            case 14: {
                return this.amount;
            }
            case 13: {
                return this.amount * 1000L;
            }
            case 12: {
                return this.amount * 60000L;
            }
            case 10: {
                return this.amount * 3600000L;
            }
            case 5: {
                return this.amount * 86400000L;
            }
            case 4: {
                return this.amount * 604800000L;
            }
        }
        throw new IllegalStateException("calendar field '" + this.field + "' does not have a fixed duration");
    }

    public boolean isBusinessTime() {
        return this.isBusinessTime;
    }

    static {
        Properties businessCalendarProperties = BusinessCalendar.getBusinessCalendarProperties();
        String businessDayText = businessCalendarProperties.getProperty("business.day.expressed.in.hours");
        String businessWeekText = businessCalendarProperties.getProperty("business.week.expressed.in.hours");
        String businessMonthText = businessCalendarProperties.getProperty("business.month.expressed.in.business.days");
        String businessYearText = businessCalendarProperties.getProperty("business.year.expressed.in.business.days");
        try {
            NumberFormat format = NumberFormat.getNumberInstance(Locale.US);
            BUSINESS_DAY = Duration.multiply(format.parse(businessDayText), 3600000L);
            BUSINESS_WEEK = Duration.multiply(format.parse(businessWeekText), 3600000L);
            BUSINESS_MONTH = Duration.multiply(format.parse(businessMonthText), BUSINESS_DAY);
            BUSINESS_YEAR = Duration.multiply(format.parse(businessYearText), BUSINESS_DAY);
        }
        catch (ParseException e) {
            throw new NumberFormatException(e.getMessage());
        }
        calendarFields = new HashMap();
        Integer millisecondField = new Integer(14);
        calendarFields.put("millisecond", millisecondField);
        calendarFields.put("milliseconds", millisecondField);
        Integer secondField = new Integer(13);
        calendarFields.put("second", secondField);
        calendarFields.put("seconds", secondField);
        Integer minuteField = new Integer(12);
        calendarFields.put("minute", minuteField);
        calendarFields.put("minutes", minuteField);
        Integer hourField = new Integer(10);
        calendarFields.put("hour", hourField);
        calendarFields.put("hours", hourField);
        Integer dayField = new Integer(5);
        calendarFields.put("day", dayField);
        calendarFields.put("days", dayField);
        Integer weekField = new Integer(4);
        calendarFields.put("week", weekField);
        calendarFields.put("weeks", weekField);
        Integer monthField = new Integer(2);
        calendarFields.put("month", monthField);
        calendarFields.put("months", monthField);
        Integer yearField = new Integer(1);
        calendarFields.put("year", yearField);
        calendarFields.put("years", yearField);
        businessAmounts = new HashMap();
        Long secondAmount = new Long(1000L);
        businessAmounts.put("business second", secondAmount);
        businessAmounts.put("business seconds", secondAmount);
        Long minuteAmount = new Long(60000L);
        businessAmounts.put("business minute", minuteAmount);
        businessAmounts.put("business minutes", minuteAmount);
        Long hourAmount = new Long(3600000L);
        businessAmounts.put("business hour", hourAmount);
        businessAmounts.put("business hours", hourAmount);
        Long dayAmount = new Long(BUSINESS_DAY);
        businessAmounts.put("business day", dayAmount);
        businessAmounts.put("business days", dayAmount);
        Long weekAmount = new Long(BUSINESS_WEEK);
        businessAmounts.put("business week", weekAmount);
        businessAmounts.put("business weeks", weekAmount);
        Long monthAmount = new Long(BUSINESS_MONTH);
        businessAmounts.put("business month", monthAmount);
        businessAmounts.put("business months", monthAmount);
        Long yearAmount = new Long(BUSINESS_YEAR);
        businessAmounts.put("business year", yearAmount);
        businessAmounts.put("business years", yearAmount);
    }
}

