/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.node;

import java.util.Map;
import org.drools.common.InternalWorkingMemory;
import org.drools.event.rule.ActivationCancelledEvent;
import org.drools.event.rule.ActivationCreatedEvent;
import org.drools.event.rule.AfterActivationFiredEvent;
import org.drools.event.rule.AgendaEventListener;
import org.drools.event.rule.AgendaGroupPoppedEvent;
import org.drools.event.rule.AgendaGroupPushedEvent;
import org.drools.event.rule.BeforeActivationFiredEvent;
import org.drools.event.rule.RuleFlowGroupActivatedEvent;
import org.drools.event.rule.RuleFlowGroupDeactivatedEvent;
import org.drools.impl.StatefulKnowledgeSessionImpl;
import org.drools.rule.Declaration;
import org.drools.rule.Rule;
import org.drools.runtime.process.NodeInstance;
import org.drools.runtime.rule.impl.InternalAgenda;
import org.drools.spi.Activation;
import org.jbpm.process.instance.ProcessInstance;
import org.jbpm.workflow.core.node.MilestoneNode;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.jbpm.workflow.instance.node.StateBasedNodeInstance;

public class MilestoneNodeInstance
extends StateBasedNodeInstance
implements AgendaEventListener {
    private static final long serialVersionUID = 510L;

    protected MilestoneNode getMilestoneNode() {
        return (MilestoneNode)this.getNode();
    }

    public void internalTrigger(NodeInstance from, String type) {
        super.internalTrigger(from, type);
        if (!"DROOLS_DEFAULT".equals(type)) {
            throw new IllegalArgumentException("A MilestoneNode only accepts default incoming connections!");
        }
        String rule = "RuleFlow-Milestone-" + this.getProcessInstance().getProcessId() + "-" + this.getMilestoneNode().getUniqueId();
        boolean isActive = ((InternalAgenda)this.getProcessInstance().getKnowledgeRuntime().getAgenda()).isRuleActiveInRuleFlowGroup("DROOLS_SYSTEM", rule, this.getProcessInstance().getId());
        if (isActive) {
            this.triggerCompleted();
        } else {
            this.addActivationListener();
        }
    }

    private boolean checkProcessInstance(Activation activation) {
        Map declarations = activation.getSubRule().getOuterDeclarations();
        for (Declaration declaration : declarations.values()) {
            Object value;
            if (!"processInstance".equals(declaration.getIdentifier()) || !((value = declaration.getValue((InternalWorkingMemory)((StatefulKnowledgeSessionImpl)this.getProcessInstance().getKnowledgeRuntime()).session, activation.getTuple().get(declaration).getObject())) instanceof ProcessInstance)) continue;
            return ((ProcessInstance)value).getId() == this.getProcessInstance().getId();
        }
        return true;
    }

    public void addEventListeners() {
        super.addEventListeners();
        this.addActivationListener();
    }

    private void addActivationListener() {
        this.getProcessInstance().getKnowledgeRuntime().addEventListener((AgendaEventListener)this);
    }

    public void removeEventListeners() {
        super.removeEventListeners();
        this.getProcessInstance().getKnowledgeRuntime().removeEventListener((AgendaEventListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activationCreated(ActivationCreatedEvent event) {
        String ruleFlowGroup = ((Rule)event.getActivation().getRule()).getRuleFlowGroup();
        if ("DROOLS_SYSTEM".equals(ruleFlowGroup)) {
            String ruleName = event.getActivation().getRule().getName();
            String milestoneName = "RuleFlow-Milestone-" + this.getProcessInstance().getProcessId() + "-" + this.getNodeId();
            if (milestoneName.equals(ruleName) && this.checkProcessInstance((Activation)event.getActivation())) {
                if (!this.getProcessInstance().getKnowledgeRuntime().getActionQueue().isEmpty()) {
                    this.getProcessInstance().getKnowledgeRuntime().executeQueuedActions();
                }
                WorkflowProcessInstance workflowProcessInstance = this.getProcessInstance();
                synchronized (workflowProcessInstance) {
                    this.removeEventListeners();
                    this.triggerCompleted();
                }
            }
        }
    }

    public void activationCancelled(ActivationCancelledEvent event) {
    }

    public void afterActivationFired(AfterActivationFiredEvent event) {
    }

    public void agendaGroupPopped(AgendaGroupPoppedEvent event) {
    }

    public void agendaGroupPushed(AgendaGroupPushedEvent event) {
    }

    public void beforeActivationFired(BeforeActivationFiredEvent event) {
    }

    public void afterRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event) {
    }

    public void afterRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event) {
    }

    public void beforeRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event) {
    }

    public void beforeRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event) {
    }
}

