/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net.jsse;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPathParameters;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.util.Collection;
import java.util.Locale;
import java.util.Vector;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import org.apache.tomcat.util.net.DefaultNioServerSocketChannelFactory;
import org.apache.tomcat.util.net.NioChannel;
import org.apache.tomcat.util.net.jsse.JSSEKeyManager;
import org.apache.tomcat.util.net.jsse.SecureNioChannel;
import org.jboss.web.CoyoteLogger;
import org.jboss.web.CoyoteMessages;

public class NioJSSESocketChannelFactory
extends DefaultNioServerSocketChannelFactory {
    private static final boolean RFC_5746_SUPPORTED;
    private static final String defaultProtocol = "TLS";
    static boolean defaultClientAuth;
    static String defaultKeystoreType;
    private static final String defaultKeystoreFile;
    private static final String defaultKeyPass = "changeit";
    private static final int defaultSessionCacheSize = 0;
    private static final int defaultSessionTimeout = 86400;
    protected boolean initialized;
    private SSLContext sslContext;
    protected String clientAuth = "false";
    protected String[] enabledCiphers;
    protected boolean allowUnsafeLegacyRenegotiation = false;
    protected boolean requireClientAuth = false;
    protected boolean wantClientAuth = false;

    public NioJSSESocketChannelFactory() {
    }

    public NioJSSESocketChannelFactory(AsynchronousChannelGroup threadGroup) {
        super(threadGroup);
    }

    @Override
    public NioChannel acceptChannel(AsynchronousServerSocketChannel listener) throws IOException {
        try {
            AsynchronousSocketChannel asyncChannel = listener.accept().get();
            InetSocketAddress addr = (InetSocketAddress)asyncChannel.getRemoteAddress();
            SSLEngine engine = this.sslContext.createSSLEngine(addr.getHostString(), addr.getPort());
            SecureNioChannel channel = new SecureNioChannel(asyncChannel, engine);
            return channel;
        }
        catch (Exception e) {
            throw new IOException(CoyoteMessages.MESSAGES.sslHandshakeError(), e);
        }
    }

    @Override
    public void initChannel(NioChannel channel) throws Exception {
        SecureNioChannel sslChannel = (SecureNioChannel)channel;
        this.initSSLEngine(sslChannel.getSslEngine());
    }

    @Override
    public void handshake(NioChannel channel) throws IOException {
        SecureNioChannel sslChannel = (SecureNioChannel)channel;
        if (sslChannel.handshakeComplete()) {
            return;
        }
        SSLEngine engine = sslChannel.getSslEngine();
        if (!this.allowUnsafeLegacyRenegotiation && !RFC_5746_SUPPORTED) {
            engine.setEnabledCipherSuites(new String[0]);
        }
        sslChannel.handshake();
        if (sslChannel.getSSLSession().getCipherSuite().equals("SSL_NULL_WITH_NULL_NULL")) {
            throw new IOException(CoyoteMessages.MESSAGES.invalidSslCipherSuite());
        }
    }

    public void setSslContext(SSLContext ctx) {
        this.sslContext = ctx;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    @Override
    public void init() throws IOException {
        try {
            String keystoreType;
            String algorithm;
            String clientAuthStr = (String)this.attributes.get("clientauth");
            if ("true".equalsIgnoreCase(clientAuthStr) || "yes".equalsIgnoreCase(clientAuthStr)) {
                this.requireClientAuth = true;
            } else if ("want".equalsIgnoreCase(clientAuthStr)) {
                this.wantClientAuth = true;
            }
            String protocol = (String)this.attributes.get("protocol");
            if (protocol == null) {
                protocol = defaultProtocol;
            }
            if ((algorithm = (String)this.attributes.get("algorithm")) == null) {
                algorithm = KeyManagerFactory.getDefaultAlgorithm();
            }
            if ((keystoreType = (String)this.attributes.get("keystoreType")) == null) {
                keystoreType = defaultKeystoreType;
            }
            String keystoreProvider = (String)this.attributes.get("keystoreProvider");
            String trustAlgorithm = (String)this.attributes.get("truststoreAlgorithm");
            if (trustAlgorithm == null) {
                trustAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
            }
            this.sslContext = (SSLContext)this.attributes.get("SSLContext");
            if (this.sslContext == null) {
                this.sslContext = SSLContext.getInstance(protocol);
                this.sslContext.init(this.getKeyManagers(keystoreType, keystoreProvider, algorithm, (String)this.attributes.get("keyAlias")), this.getTrustManagers(keystoreType, keystoreProvider, trustAlgorithm), new SecureRandom());
            }
            int sessionCacheSize = this.attributes.get("sessionCacheSize") != null ? Integer.parseInt((String)this.attributes.get("sessionCacheSize")) : 0;
            int sessionCacheTimeout = this.attributes.get("sessionCacheTimeout") != null ? Integer.parseInt((String)this.attributes.get("sessionCacheTimeout")) : 86400;
            SSLSessionContext sessionContext = this.sslContext.getServerSessionContext();
            if (sessionContext != null) {
                sessionContext.setSessionCacheSize(sessionCacheSize);
                sessionContext.setSessionTimeout(sessionCacheTimeout);
            }
            SSLServerSocketFactory sslProxy = this.sslContext.getServerSocketFactory();
            String requestedCiphers = (String)this.attributes.get("ciphers");
            this.enabledCiphers = this.getEnabledCiphers(requestedCiphers, sslProxy.getSupportedCipherSuites());
            this.allowUnsafeLegacyRenegotiation = "true".equals(this.attributes.get("allowUnsafeLegacyRenegotiation"));
            this.checkConfig();
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    @Override
    public void destroy() throws IOException {
        super.destroy();
        this.sslContext = null;
    }

    protected String[] getEnabledCiphers(String requestedCiphers, String[] supportedCiphers) {
        Object[] enabledCiphers = null;
        SSLServerSocketFactory sslProxy = this.sslContext.getServerSocketFactory();
        if (requestedCiphers != null) {
            Vector<String> vec = null;
            String cipher = requestedCiphers;
            int index = requestedCiphers.indexOf(44);
            if (index != -1) {
                int fromIndex = 0;
                while (index != -1) {
                    cipher = requestedCiphers.substring(fromIndex, index).trim();
                    if (cipher.length() > 0) {
                        for (int i = 0; supportedCiphers != null && i < supportedCiphers.length; ++i) {
                            if (!supportedCiphers[i].equals(cipher)) continue;
                            if (vec == null) {
                                vec = new Vector();
                            }
                            vec.addElement(cipher);
                            break;
                        }
                    }
                    fromIndex = index + 1;
                    index = requestedCiphers.indexOf(44, fromIndex);
                }
                cipher = requestedCiphers.substring(fromIndex);
            }
            if (cipher != null && (cipher = cipher.trim()).length() > 0) {
                for (int i = 0; supportedCiphers != null && i < supportedCiphers.length; ++i) {
                    if (!supportedCiphers[i].equals(cipher)) continue;
                    if (vec == null) {
                        vec = new Vector<String>();
                    }
                    vec.addElement(cipher);
                    break;
                }
            }
            if (vec != null) {
                enabledCiphers = new String[vec.size()];
                vec.copyInto(enabledCiphers);
            }
        } else {
            enabledCiphers = sslProxy.getDefaultCipherSuites();
        }
        return enabledCiphers;
    }

    protected KeyStore getKeystore(String type, String provider, String pass) throws IOException {
        String keystoreFile = (String)this.attributes.get("keystore");
        if (keystoreFile == null) {
            keystoreFile = defaultKeystoreFile;
        }
        return this.getStore(type, provider, keystoreFile, pass);
    }

    protected String getKeystorePassword() {
        String keystorePass;
        String keyPass = (String)this.attributes.get("keypass");
        if (keyPass == null) {
            keyPass = defaultKeyPass;
        }
        if ((keystorePass = (String)this.attributes.get("keystorePass")) == null) {
            keystorePass = keyPass;
        }
        return keystorePass;
    }

    private KeyStore getStore(String type, String provider, String path, String pass) throws IOException {
        KeyStore ks = null;
        InputStream istream = null;
        try {
            ks = provider == null ? KeyStore.getInstance(type) : KeyStore.getInstance(type, provider);
            if (!"PKCS11".equalsIgnoreCase(type) && !"".equalsIgnoreCase(path)) {
                File keyStoreFile = new File(path);
                if (!keyStoreFile.isAbsolute()) {
                    keyStoreFile = new File(System.getProperty("catalina.base"), path);
                }
                istream = new FileInputStream(keyStoreFile);
            }
            char[] storePass = null;
            if (pass != null) {
                storePass = pass.toCharArray();
            }
            ks.load(istream, storePass);
        }
        catch (FileNotFoundException fnfe) {
            CoyoteLogger.UTIL_LOGGER.errorLoadingKeystore(type, path, fnfe.getMessage());
            throw fnfe;
        }
        catch (IOException ioe) {
            CoyoteLogger.UTIL_LOGGER.errorLoadingKeystoreWithException(type, path, ioe.getMessage(), ioe);
            throw ioe;
        }
        catch (Exception ex) {
            CoyoteLogger.UTIL_LOGGER.errorLoadingKeystoreWithException(type, path, ex.getMessage(), ex);
            throw new IOException(ex);
        }
        finally {
            if (istream != null) {
                try {
                    istream.close();
                }
                catch (IOException ioe) {}
            }
        }
        return ks;
    }

    protected KeyManager[] getKeyManagers(String keystoreType, String keystoreProvider, String algorithm, String keyAlias) throws Exception {
        KeyManager[] kms = null;
        String keystorePass = this.getKeystorePassword();
        KeyStore ks = this.getKeystore(keystoreType, keystoreProvider, keystorePass);
        if (keyAlias != null && !ks.isKeyEntry(keyAlias)) {
            throw new IOException(CoyoteMessages.MESSAGES.noKeyAlias(keyAlias));
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
        kmf.init(ks, keystorePass.toCharArray());
        kms = kmf.getKeyManagers();
        if (keyAlias != null) {
            if (defaultKeystoreType.equals(keystoreType)) {
                keyAlias = keyAlias.toLowerCase(Locale.ENGLISH);
            }
            for (int i = 0; i < kms.length; ++i) {
                kms[i] = new JSSEKeyManager((X509KeyManager)kms[i], keyAlias);
            }
        }
        return kms;
    }

    protected TrustManager[] getTrustManagers(String keystoreType, String keystoreProvider, String algorithm) throws Exception {
        String crlf = (String)this.attributes.get("crlFile");
        TrustManager[] tms = null;
        KeyStore trustStore = this.getTrustStore(keystoreType, keystoreProvider);
        if (trustStore != null) {
            if (crlf == null) {
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm);
                tmf.init(trustStore);
                tms = tmf.getTrustManagers();
            } else {
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm);
                CertPathParameters params = this.getParameters(algorithm, crlf, trustStore);
                CertPathTrustManagerParameters mfp = new CertPathTrustManagerParameters(params);
                tmf.init(mfp);
                tms = tmf.getTrustManagers();
            }
        }
        return tms;
    }

    protected KeyStore getTrustStore(String keystoreType, String keystoreProvider) throws IOException {
        String truststoreProvider;
        String truststoreType;
        String truststorePassword;
        KeyStore trustStore = null;
        String truststoreFile = (String)this.attributes.get("truststoreFile");
        if (truststoreFile == null) {
            truststoreFile = System.getProperty("javax.net.ssl.trustStore");
        }
        if (CoyoteLogger.UTIL_LOGGER.isDebugEnabled()) {
            CoyoteLogger.UTIL_LOGGER.debug("Truststore = " + truststoreFile);
        }
        if ((truststorePassword = (String)this.attributes.get("truststorePass")) == null) {
            truststorePassword = System.getProperty("javax.net.ssl.trustStorePassword");
        }
        if (CoyoteLogger.UTIL_LOGGER.isDebugEnabled()) {
            CoyoteLogger.UTIL_LOGGER.debug("TrustPass = " + truststorePassword);
        }
        if ((truststoreType = (String)this.attributes.get("truststoreType")) == null) {
            truststoreType = System.getProperty("javax.net.ssl.trustStoreType");
        }
        if (truststoreType == null) {
            truststoreType = keystoreType;
        }
        if (CoyoteLogger.UTIL_LOGGER.isDebugEnabled()) {
            CoyoteLogger.UTIL_LOGGER.debug("trustType = " + truststoreType);
        }
        if ((truststoreProvider = (String)this.attributes.get("truststoreProvider")) == null) {
            truststoreProvider = System.getProperty("javax.net.ssl.trustStoreProvider");
        }
        if (truststoreProvider == null) {
            truststoreProvider = keystoreProvider;
        }
        if (CoyoteLogger.UTIL_LOGGER.isDebugEnabled()) {
            CoyoteLogger.UTIL_LOGGER.debug("trustProvider = " + truststoreProvider);
        }
        if (truststoreFile != null) {
            trustStore = this.getStore(truststoreType, truststoreProvider, truststoreFile, truststorePassword);
        }
        return trustStore;
    }

    protected CertPathParameters getParameters(String algorithm, String crlf, KeyStore trustStore) throws Exception {
        PKIXBuilderParameters xparams;
        PKIXBuilderParameters params = null;
        if ("PKIX".equalsIgnoreCase(algorithm)) {
            xparams = new PKIXBuilderParameters(trustStore, (CertSelector)new X509CertSelector());
            Collection<? extends CRL> crls = this.getCRLs(crlf);
            CollectionCertStoreParameters csp = new CollectionCertStoreParameters(crls);
            CertStore store = CertStore.getInstance("Collection", csp);
            xparams.addCertStore(store);
            xparams.setRevocationEnabled(true);
            String trustLength = (String)this.attributes.get("trustMaxCertLength");
            if (trustLength != null) {
                try {
                    xparams.setMaxPathLength(Integer.parseInt(trustLength));
                }
                catch (Exception ex) {
                    CoyoteLogger.UTIL_LOGGER.invalidMaxCertLength(trustLength);
                }
            }
        } else {
            throw new CRLException(CoyoteMessages.MESSAGES.unsupportedCrl(algorithm));
        }
        params = xparams;
        return params;
    }

    protected Collection<? extends CRL> getCRLs(String crlf) throws IOException, CRLException, CertificateException {
        File crlFile = new File(crlf);
        if (!crlFile.isAbsolute()) {
            crlFile = new File(System.getProperty("catalina.base"), crlf);
        }
        Collection<? extends CRL> crls = null;
        InputStream is = null;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            is = new FileInputStream(crlFile);
            crls = cf.generateCRLs(is);
        }
        catch (IOException iex) {
            throw iex;
        }
        catch (CRLException crle) {
            throw crle;
        }
        catch (CertificateException ce) {
            throw ce;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception ex) {}
            }
        }
        return crls;
    }

    protected void setEnabledProtocols(SSLEngine engine, String[] protocols) {
        if (protocols != null) {
            engine.setEnabledProtocols(protocols);
        }
    }

    protected String[] getEnabledProtocols(SSLEngine engine, String requestedProtocols) {
        String[] supportedProtocols = engine.getSupportedProtocols();
        Object[] enabledProtocols = null;
        if (requestedProtocols != null) {
            Vector<String> vec = null;
            String[] tab = requestedProtocols.trim().split("\\s*,\\s*");
            if (tab.length > 0) {
                vec = new Vector<String>(tab.length);
            }
            block0: for (String s : tab) {
                if (s.length() <= 0) continue;
                for (int i = 0; supportedProtocols != null && i < supportedProtocols.length; ++i) {
                    if (!supportedProtocols[i].equals(s)) continue;
                    vec.addElement(s);
                    continue block0;
                }
            }
            if (vec != null && !vec.isEmpty()) {
                enabledProtocols = new String[vec.size()];
                vec.copyInto(enabledProtocols);
            }
        }
        return enabledProtocols;
    }

    private void initSSLEngine(SSLEngine engine) {
        if (this.enabledCiphers != null) {
            engine.setEnabledCipherSuites(this.enabledCiphers);
        }
        engine.setUseClientMode(false);
        String requestedProtocols = (String)this.attributes.get("protocols");
        this.setEnabledProtocols(engine, this.getEnabledProtocols(engine, requestedProtocols));
        engine.setWantClientAuth(this.wantClientAuth);
        engine.setNeedClientAuth(this.requireClientAuth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkConfig() throws IOException {
        SSLServerSocketFactory sslProxy = this.sslContext.getServerSocketFactory();
        ServerSocket socket = sslProxy.createServerSocket();
        try {
            socket.setSoTimeout(1);
            socket.accept();
        }
        catch (SSLException ssle) {
            IOException ioe = new IOException(CoyoteMessages.MESSAGES.invalidSSLConfiguration(ssle.getMessage()));
            ioe.initCause(ssle);
            throw ioe;
        }
        catch (Exception exception) {
        }
        finally {
            if (!socket.isClosed()) {
                socket.close();
            }
        }
    }

    static {
        defaultClientAuth = false;
        defaultKeystoreType = "JKS";
        defaultKeystoreFile = System.getProperty("user.home") + "/.keystore";
        boolean result = false;
        try {
            String[] ciphers;
            SSLContext context = SSLContext.getInstance(defaultProtocol);
            context.init(null, null, new SecureRandom());
            SSLServerSocketFactory ssf = context.getServerSocketFactory();
            for (String cipher : ciphers = ssf.getSupportedCipherSuites()) {
                if (!"TLS_EMPTY_RENEGOTIATION_INFO_SCSV".equals(cipher)) continue;
                result = true;
                break;
            }
        }
        catch (NoSuchAlgorithmException e) {
        }
        catch (KeyManagementException keyManagementException) {
            // empty catch block
        }
        RFC_5746_SUPPORTED = result;
    }
}

