/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http.fileupload;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.jboss.web.FileUploadMessages;

public class FileUtils {
    public static void deleteDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            return;
        }
        FileUtils.cleanDirectory(directory);
        if (!directory.delete()) {
            throw new IOException(FileUploadMessages.MESSAGES.failedToDeleteDirectory(directory.getPath()));
        }
    }

    public static void cleanDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            throw FileUploadMessages.MESSAGES.missingDirectory(directory.getPath());
        }
        if (!directory.isDirectory()) {
            throw FileUploadMessages.MESSAGES.notDirectory(directory.getPath());
        }
        File[] files = directory.listFiles();
        if (files == null) {
            throw new IOException(FileUploadMessages.MESSAGES.failedListingDirectory(directory.getPath()));
        }
        IOException exception = null;
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            try {
                FileUtils.forceDelete(file);
                continue;
            }
            catch (IOException ioe) {
                exception = ioe;
            }
        }
        if (null != exception) {
            throw exception;
        }
    }

    public static void forceDelete(File file) throws IOException {
        if (file.isDirectory()) {
            FileUtils.deleteDirectory(file);
        } else {
            boolean filePresent = file.exists();
            if (!file.delete()) {
                if (!filePresent) {
                    throw new FileNotFoundException(FileUploadMessages.MESSAGES.missingFile(file.getPath()));
                }
                throw new IOException(FileUploadMessages.MESSAGES.failedToDelete(file.getPath()));
            }
        }
    }

    public static void forceDeleteOnExit(File file) throws IOException {
        if (file.isDirectory()) {
            FileUtils.deleteDirectoryOnExit(file);
        } else {
            file.deleteOnExit();
        }
    }

    private static void deleteDirectoryOnExit(File directory) throws IOException {
        if (!directory.exists()) {
            return;
        }
        FileUtils.cleanDirectoryOnExit(directory);
        directory.deleteOnExit();
    }

    private static void cleanDirectoryOnExit(File directory) throws IOException {
        if (!directory.exists()) {
            throw FileUploadMessages.MESSAGES.missingDirectory(directory.getPath());
        }
        if (!directory.isDirectory()) {
            throw FileUploadMessages.MESSAGES.notDirectory(directory.getPath());
        }
        File[] files = directory.listFiles();
        if (files == null) {
            throw new IOException(FileUploadMessages.MESSAGES.failedListingDirectory(directory.getPath()));
        }
        IOException exception = null;
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            try {
                FileUtils.forceDeleteOnExit(file);
                continue;
            }
            catch (IOException ioe) {
                exception = ioe;
            }
        }
        if (null != exception) {
            throw exception;
        }
    }
}

