/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.solder.servlet.event;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jboss.solder.core.Requires;
import org.jboss.solder.logging.Category;
import org.jboss.solder.servlet.ServletRequestContext;
import org.jboss.solder.servlet.beanManager.ServletContextAttributeProvider;
import org.jboss.solder.servlet.event.Destroyed;
import org.jboss.solder.servlet.event.Initialized;
import org.jboss.solder.servlet.http.HttpServletRequestContext;
import org.jboss.solder.servlet.support.ServletLogger;

@Requires(value={"javax.servlet.Servlet"})
@ApplicationScoped
public class ImplicitServletObjectsHolder {
    @Inject
    @Category(value="solder-servlet")
    private ServletLogger log;
    private ServletContext servletCtx;
    private final ThreadLocal<ServletRequestContext> requestCtx = new ThreadLocal<ServletRequestContext>(){

        @Override
        protected ServletRequestContext initialValue() {
            return null;
        }
    };

    protected void contextInitialized(@Observes @Initialized InternalServletContextEvent e, BeanManager beanManager) {
        ServletContext ctx = e.getServletContext();
        this.log.servletContextInitialized(ctx);
        ctx.setAttribute(BeanManager.class.getName(), (Object)beanManager);
        ServletContextAttributeProvider.setServletContext(ctx);
        this.servletCtx = ctx;
    }

    protected void contextDestroyed(@Observes @Destroyed InternalServletContextEvent e) {
        this.log.servletContextDestroyed(e.getServletContext());
        this.servletCtx = null;
    }

    protected void requestInitialized(@Observes @Initialized InternalServletRequestEvent e) {
        ServletRequest req = e.getServletRequest();
        this.log.servletRequestInitialized(req);
        if (req instanceof HttpServletRequest) {
            this.requestCtx.set((ServletRequestContext)new HttpServletRequestContext(req));
        } else {
            this.requestCtx.set(new ServletRequestContext(req));
        }
    }

    protected void requestDestroyed(@Observes @Destroyed InternalServletRequestEvent e) {
        this.log.servletRequestDestroyed(e.getServletRequest());
        this.requestCtx.set(null);
    }

    protected void responseInitialized(@Observes @Initialized InternalServletResponseEvent e) {
        ServletResponse res = e.getServletResponse();
        this.log.servletResponseInitialized(res);
        if (res instanceof HttpServletResponse) {
            this.requestCtx.set((ServletRequestContext)new HttpServletRequestContext(this.requestCtx.get().getRequest(), res));
        } else {
            this.requestCtx.set(new ServletRequestContext(this.requestCtx.get().getRequest(), res));
        }
    }

    protected void responseDestroyed(@Observes @Destroyed InternalServletResponseEvent e) {
        this.log.servletResponseDestroyed(e.getServletResponse());
        if (this.requestCtx.get() instanceof HttpServletRequestContext) {
            this.requestCtx.set((ServletRequestContext)new HttpServletRequestContext(this.requestCtx.get().getRequest()));
        } else {
            this.requestCtx.set(new ServletRequestContext(this.requestCtx.get().getRequest()));
        }
    }

    public ServletContext getServletContext() {
        return this.servletCtx;
    }

    public ServletRequestContext getServletRequestContext() {
        return this.requestCtx.get();
    }

    public HttpServletRequestContext getHttpServletRequestContext() {
        if (this.requestCtx.get() instanceof HttpServletRequestContext) {
            return (HttpServletRequestContext)HttpServletRequestContext.class.cast(this.requestCtx.get());
        }
        return null;
    }

    public ServletRequest getServletRequest() {
        if (this.requestCtx.get() != null) {
            return this.requestCtx.get().getRequest();
        }
        return null;
    }

    public HttpServletRequest getHttpServletRequest() {
        if (this.requestCtx.get() instanceof HttpServletRequestContext) {
            return ((HttpServletRequestContext)HttpServletRequestContext.class.cast(this.requestCtx.get())).getRequest();
        }
        return null;
    }

    public ServletResponse getServletResponse() {
        if (this.requestCtx.get() != null) {
            return this.requestCtx.get().getResponse();
        }
        return null;
    }

    public HttpServletResponse getHttpServletResponse() {
        if (this.requestCtx.get() instanceof HttpServletRequestContext) {
            return ((HttpServletRequestContext)HttpServletRequestContext.class.cast(this.requestCtx.get())).getResponse();
        }
        return null;
    }

    public HttpSession getHttpSession() {
        if (this.requestCtx.get() instanceof HttpServletRequestContext) {
            return ((HttpServletRequestContext)HttpServletRequestContext.class.cast(this.requestCtx.get())).getRequest().getSession();
        }
        return null;
    }

    static class InternalHttpSessionEvent {
        private HttpSession session;

        InternalHttpSessionEvent(HttpSession session) {
            this.session = session;
        }

        public HttpSession getHttpSession() {
            return this.session;
        }
    }

    static class InternalServletResponseEvent {
        private ServletResponse response;

        InternalServletResponseEvent(ServletResponse response) {
            this.response = response;
        }

        public ServletResponse getServletResponse() {
            return this.response;
        }
    }

    static class InternalServletRequestEvent {
        private ServletRequest request;

        InternalServletRequestEvent(ServletRequest request) {
            this.request = request;
        }

        public ServletRequest getServletRequest() {
            return this.request;
        }
    }

    static class InternalServletContextEvent {
        private ServletContext ctx;

        InternalServletContextEvent(ServletContext ctx) {
            this.ctx = ctx;
        }

        public ServletContext getServletContext() {
            return this.ctx;
        }
    }
}

