/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.config.xml.parser;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.jboss.seam.config.xml.parser.SaxNode;
import org.jboss.seam.config.xml.util.XmlParseException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserMain
extends DefaultHandler {
    SaxNode parentNode = null;
    SaxNode currentNode = null;
    Locator locator;
    String currentText = "";
    String document;
    List<Exception> errors;

    public SaxNode parse(InputSource inputSource, String fileUrl, List<Exception> errors) {
        this.errors = errors;
        this.document = fileUrl;
        try {
            XMLReader xr = XMLReaderFactory.createXMLReader();
            xr.setContentHandler(this);
            xr.setErrorHandler(this);
            xr.parse(inputSource);
            return this.parentNode;
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.currentText = this.currentText + new String(ch, start, length);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        HashMap<String, String> atmap = new HashMap<String, String>();
        for (int i = 0; i < attributes.getLength(); ++i) {
            atmap.put(attributes.getLocalName(i), attributes.getValue(i));
        }
        int pos = 0;
        if (this.locator != null) {
            pos = this.locator.getLineNumber();
        }
        SaxNode node = new SaxNode(localName, uri, atmap, this.currentNode, this.document, pos);
        if (this.currentNode == null) {
            this.parentNode = node;
        } else {
            this.currentNode.addChild(node);
        }
        this.currentNode = node;
        this.currentText = "";
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.currentNode.setInnerText(this.currentText);
        this.currentNode = this.currentNode.getParent();
        this.currentText = "";
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        this.errors.add(new XmlParseException(e, this.document, e.getLineNumber()));
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        this.errors.add(new XmlParseException(e, this.document, e.getLineNumber()));
    }
}

