/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.config.xml.fieldset;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.BeanManager;
import org.jboss.seam.config.xml.fieldset.FieldValue;
import org.jboss.seam.config.xml.fieldset.FieldValueObject;
import org.jboss.seam.config.xml.model.ValueXmlItem;
import org.jboss.seam.solder.properties.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayFieldSet
implements FieldValueObject {
    private final Property<Object> field;
    private final List<FieldValue> values;
    private final Class<?> arrayType;

    public ArrayFieldSet(Property<Object> field, List<ValueXmlItem> items) {
        this.field = field;
        this.values = new ArrayList<FieldValue>();
        this.arrayType = field.getJavaClass().getComponentType();
        for (ValueXmlItem i : items) {
            this.values.add(i.getValue());
        }
    }

    @Override
    public void setValue(Object instance, CreationalContext<?> ctx, BeanManager manager) {
        try {
            Object array = Array.newInstance(this.arrayType, this.values.size());
            this.field.setValue(instance, array);
            for (int i = 0; i < this.values.size(); ++i) {
                Array.set(array, i, this.values.get(i).value(this.arrayType, ctx, manager));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

