/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.config.xml.core;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.seam.config.xml.core.BeanResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlResult
implements Comparable<XmlResult> {
    private final Map<Class<? extends Annotation>, Annotation[]> stereotypes = new HashMap<Class<? extends Annotation>, Annotation[]>();
    private final List<Class<? extends Annotation>> qualifiers = new ArrayList<Class<? extends Annotation>>();
    private final List<Class<? extends Annotation>> interceptorBindings = new ArrayList<Class<? extends Annotation>>();
    private final List<Class<?>> veto = new ArrayList();
    private final List<String> problems = new ArrayList<String>();
    private final List<BeanResult<?>> beans = new ArrayList();
    private final String sortKey;

    public XmlResult(String fileUrl) {
        StringBuilder keyBuilder = new StringBuilder(fileUrl.length());
        for (int i = fileUrl.length() - 1; i >= 0; --i) {
            keyBuilder.append(fileUrl.charAt(i));
        }
        this.sortKey = keyBuilder.toString();
    }

    public void addStereotype(Class<? extends Annotation> an, Annotation[] values) {
        this.stereotypes.put(an, values);
    }

    public Map<Class<? extends Annotation>, Annotation[]> getStereotypes() {
        return this.stereotypes;
    }

    public void addQualifier(Class<? extends Annotation> qualifier) {
        this.qualifiers.add(qualifier);
    }

    public List<Class<? extends Annotation>> getQualifiers() {
        return this.qualifiers;
    }

    public void addInterceptorBinding(Class<? extends Annotation> binding) {
        this.interceptorBindings.add(binding);
    }

    public List<Class<? extends Annotation>> getInterceptorBindings() {
        return this.interceptorBindings;
    }

    public void addBean(BeanResult<?> bean) {
        this.beans.add(bean);
    }

    public List<BeanResult<?>> getBeans() {
        return this.beans;
    }

    public List<BeanResult<?>> getFlattenedBeans() {
        ArrayList results = new ArrayList();
        for (BeanResult<?> a : this.beans) {
            this.getFlattenedBeans(a, results);
        }
        return results;
    }

    private void getFlattenedBeans(BeanResult<?> r, List<BeanResult<?>> results) {
        results.add(r);
        for (BeanResult<?> a : r.getInlineBeans()) {
            this.getFlattenedBeans(a, results);
        }
    }

    public List<String> getProblems() {
        return this.problems;
    }

    public void addProblem(String p) {
        this.problems.add(p);
    }

    public void addVeto(Class<?> clazz) {
        this.veto.add(clazz);
    }

    public List<Class<?>> getVeto() {
        return this.veto;
    }

    @Override
    public int compareTo(XmlResult o) {
        return this.sortKey.compareTo(o.sortKey);
    }
}

