/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpRequestPreprocessor;
import org.jboss.resteasy.util.MediaTypeHelper;

public class AcceptParameterHttpPreprocessor
implements HttpRequestPreprocessor {
    private final String paramMapping;

    public AcceptParameterHttpPreprocessor(String paramMapping) {
        if (paramMapping == null || paramMapping.matches("\\s+")) {
            throw new IllegalArgumentException(Messages.MESSAGES.constructorMappingInvalid());
        }
        this.paramMapping = paramMapping;
    }

    @Override
    public void preProcess(HttpRequest request) {
        List accepts;
        MultivaluedMap params = request.getUri().getQueryParameters(false);
        if (params != null && (accepts = (List)params.get((Object)this.paramMapping)) != null && !accepts.isEmpty()) {
            ArrayList<MediaType> mediaTypes = new ArrayList<MediaType>();
            for (String accept : accepts) {
                try {
                    accept = URLDecoder.decode(accept, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
                mediaTypes.addAll(MediaTypeHelper.parseHeader(accept));
            }
            MediaTypeHelper.sortByWeight(mediaTypes);
            request.getHttpHeaders().getAcceptableMediaTypes().addAll(0, mediaTypes);
        }
    }
}

