/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Function;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotAcceptableException;
import javax.ws.rs.NotAllowedException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.NotSupportedException;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.RedirectionException;
import javax.ws.rs.ServerErrorException;
import javax.ws.rs.ServiceUnavailableException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.InvocationCallback;
import javax.ws.rs.client.ResponseProcessingException;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import javax.ws.rs.ext.Providers;
import javax.ws.rs.ext.WriterInterceptor;
import org.jboss.resteasy.client.exception.WebApplicationExceptionWrapper;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.engines.AsyncClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.engines.ReactiveClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.i18n.LogMessages;
import org.jboss.resteasy.client.jaxrs.internal.AbortedResponse;
import org.jboss.resteasy.client.jaxrs.internal.ClientConfiguration;
import org.jboss.resteasy.client.jaxrs.internal.ClientRequestContextImpl;
import org.jboss.resteasy.client.jaxrs.internal.ClientRequestHeaders;
import org.jboss.resteasy.client.jaxrs.internal.ClientResponse;
import org.jboss.resteasy.client.jaxrs.internal.ClientResponseContextImpl;
import org.jboss.resteasy.client.jaxrs.internal.proxy.ClientInvoker;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.core.interception.jaxrs.ClientWriterInterceptorContext;
import org.jboss.resteasy.plugins.providers.sse.EventInput;
import org.jboss.resteasy.specimpl.MultivaluedTreeMap;
import org.jboss.resteasy.spi.util.Types;
import org.jboss.resteasy.tracing.RESTEasyTracingLogger;
import org.jboss.resteasy.util.DelegatingOutputStream;
import org.reactivestreams.Publisher;

public class ClientInvocation
implements Invocation {
    protected RESTEasyTracingLogger tracingLogger;
    protected ResteasyClient client;
    protected ClientRequestHeaders headers;
    protected String method;
    protected Object entity;
    protected Type entityGenericType;
    protected Class<?> entityClass;
    protected Annotation[] entityAnnotations;
    protected ClientConfiguration configuration;
    protected URI uri;
    protected boolean chunked;
    protected ClientInvoker clientInvoker;
    protected WebTarget actualTarget;
    protected DelegatingOutputStream delegatingOutputStream = new DelegatingOutputStream();
    protected OutputStream entityStream = this.delegatingOutputStream;

    public ClientInvocation(ResteasyClient client, URI uri, ClientRequestHeaders headers, ClientConfiguration parent) {
        this.uri = uri;
        this.client = client;
        this.configuration = new ClientConfiguration(parent);
        this.headers = headers;
        this.initTracingSupport();
    }

    private void initTracingSupport() {
        RESTEasyTracingLogger tracingLogger = RESTEasyTracingLogger.isTracingConfigALL((Configuration)this.configuration) ? RESTEasyTracingLogger.create((String)this.toString(), (Configuration)this.configuration, (String)this.toString()) : RESTEasyTracingLogger.empty();
        this.tracingLogger = tracingLogger;
    }

    protected ClientInvocation(ClientInvocation clientInvocation) {
        this.client = clientInvocation.client;
        this.configuration = new ClientConfiguration(clientInvocation.configuration);
        this.headers = new ClientRequestHeaders(this.configuration);
        MultivaluedTreeMap.copy(clientInvocation.headers.getHeaders(), this.headers.headers);
        this.method = clientInvocation.method;
        this.entity = clientInvocation.entity;
        this.entityGenericType = clientInvocation.entityGenericType;
        this.entityClass = clientInvocation.entityClass;
        this.entityAnnotations = clientInvocation.entityAnnotations;
        this.uri = clientInvocation.uri;
        this.chunked = clientInvocation.chunked;
        this.tracingLogger = clientInvocation.tracingLogger;
        this.clientInvoker = clientInvocation.clientInvoker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T extractResult(GenericType<T> responseType, Response response, Annotation[] annotations) {
        int status = response.getStatus();
        if (status >= 200 && status < 300) {
            try {
                if (response.getMediaType() == null) {
                    T t = null;
                    return t;
                }
                Object rtn = response.readEntity(responseType, annotations);
                if ((InputStream.class.isInstance(rtn) || Reader.class.isInstance(rtn) || EventInput.class.isInstance(rtn) || Publisher.class.isInstance(rtn)) && response instanceof ClientResponse) {
                    ClientResponse clientResponse = (ClientResponse)response;
                    clientResponse.noReleaseConnection();
                }
                Object object = rtn;
                return (T)object;
            }
            catch (WebApplicationException wae) {
                try {
                    response.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw wae;
            }
            catch (Throwable throwable) {
                try {
                    response.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new ResponseProcessingException(response, throwable);
            }
            finally {
                if (response.getMediaType() == null) {
                    response.close();
                }
            }
        }
        try {
            String s = (String)String.class.cast(response.getHeaders().getFirst((Object)"resteasy.buffer.exception.entity"));
            if (s == null || Boolean.parseBoolean(s)) {
                response.bufferEntity();
            } else if (response instanceof ClientResponse) {
                try {
                    ((ClientResponse)((Object)ClientResponse.class.cast(response))).releaseConnection();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (status >= 300 && status < 400) {
                throw WebApplicationExceptionWrapper.wrap((WebApplicationException)new RedirectionException(response));
            }
            T t = ClientInvocation.handleErrorStatus(response);
            return t;
        }
        finally {
            if (response.getMediaType() == null) {
                response.close();
            }
        }
    }

    public static <T> T handleErrorStatus(Response response) {
        int status = response.getStatus();
        switch (status) {
            case 400: {
                throw WebApplicationExceptionWrapper.wrap((WebApplicationException)new BadRequestException(response));
            }
            case 401: {
                throw WebApplicationExceptionWrapper.wrap((WebApplicationException)new NotAuthorizedException(response));
            }
            case 403: {
                throw WebApplicationExceptionWrapper.wrap((WebApplicationException)new ForbiddenException(response));
            }
            case 404: {
                throw WebApplicationExceptionWrapper.wrap((WebApplicationException)new NotFoundException(response));
            }
            case 405: {
                throw WebApplicationExceptionWrapper.wrap((WebApplicationException)new NotAllowedException(response));
            }
            case 406: {
                throw WebApplicationExceptionWrapper.wrap((WebApplicationException)new NotAcceptableException(response));
            }
            case 415: {
                throw WebApplicationExceptionWrapper.wrap((WebApplicationException)new NotSupportedException(response));
            }
            case 500: {
                throw WebApplicationExceptionWrapper.wrap((WebApplicationException)new InternalServerErrorException(response));
            }
            case 503: {
                throw WebApplicationExceptionWrapper.wrap((WebApplicationException)new ServiceUnavailableException(response));
            }
        }
        if (status >= 400 && status < 500) {
            throw WebApplicationExceptionWrapper.wrap((WebApplicationException)new ClientErrorException(response));
        }
        if (status >= 500) {
            throw WebApplicationExceptionWrapper.wrap((WebApplicationException)new ServerErrorException(response));
        }
        throw WebApplicationExceptionWrapper.wrap((WebApplicationException)new WebApplicationException(response));
    }

    public ClientConfiguration getClientConfiguration() {
        return this.configuration;
    }

    public ResteasyClient getClient() {
        return this.client;
    }

    public DelegatingOutputStream getDelegatingOutputStream() {
        return this.delegatingOutputStream;
    }

    public void setDelegatingOutputStream(DelegatingOutputStream delegatingOutputStream) {
        this.delegatingOutputStream = delegatingOutputStream;
    }

    public OutputStream getEntityStream() {
        return this.entityStream;
    }

    public void setEntityStream(OutputStream entityStream) {
        this.entityStream = entityStream;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public Annotation[] getEntityAnnotations() {
        return this.entityAnnotations;
    }

    public void setEntityAnnotations(Annotation[] entityAnnotations) {
        this.entityAnnotations = entityAnnotations;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setHeaders(ClientRequestHeaders headers) {
        this.headers = headers;
    }

    public Map<String, Object> getMutableProperties() {
        return this.configuration.getMutableProperties();
    }

    public Object getEntity() {
        return this.entity;
    }

    public Type getEntityGenericType() {
        return this.entityGenericType;
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public ClientRequestHeaders getHeaders() {
        return this.headers;
    }

    public void setEntity(Entity<?> entity) {
        if (entity == null) {
            this.entity = null;
            this.entityAnnotations = null;
            this.entityClass = null;
            this.entityGenericType = null;
        } else {
            Object ent = entity.getEntity();
            this.setEntityObject(ent);
            this.entityAnnotations = entity.getAnnotations();
            Variant v = entity.getVariant();
            this.headers.setMediaType(v.getMediaType());
            this.headers.setLanguage(v.getLanguage());
            this.headers.header("Content-Encoding", null);
            this.headers.header("Content-Encoding", v.getEncoding());
        }
    }

    public void setEntityObject(Object ent) {
        if (ent instanceof GenericEntity) {
            GenericEntity genericEntity = (GenericEntity)ent;
            this.entityClass = genericEntity.getRawType();
            this.entityGenericType = genericEntity.getType();
            this.entity = genericEntity.getEntity();
        } else if (ent == null) {
            this.entity = null;
            this.entityClass = null;
            this.entityGenericType = null;
        } else {
            this.entity = ent;
            this.entityClass = ent.getClass();
            this.entityGenericType = ent.getClass();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeRequestBody(OutputStream outputStream) throws IOException {
        if (this.entity == null) {
            return;
        }
        WriterInterceptor[] interceptors = this.getWriterInterceptors();
        ClientWriterInterceptorContext ctx = new ClientWriterInterceptorContext(interceptors, this.configuration.getProviderFactory(), this.entity, this.entityClass, this.entityGenericType, this.entityAnnotations, this.headers.getMediaType(), this.headers.getHeaders(), outputStream, this.getMutableProperties(), this.tracingLogger);
        long timestamp = this.tracingLogger.timestamp("WI_SUMMARY");
        try {
            ctx.proceed();
        }
        catch (Throwable throwable) {
            this.tracingLogger.logDuration("WI_SUMMARY", timestamp, new Object[]{ctx.getProcessedInterceptorCount()});
            throw throwable;
        }
        this.tracingLogger.logDuration("WI_SUMMARY", timestamp, new Object[]{ctx.getProcessedInterceptorCount()});
    }

    public WriterInterceptor[] getWriterInterceptors() {
        return this.configuration.getWriterInterceptors(null, null);
    }

    public ClientRequestFilter[] getRequestFilters() {
        return this.configuration.getRequestFilters(null, null);
    }

    public ClientResponseFilter[] getResponseFilters() {
        return this.configuration.getResponseFilters(null, null);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public boolean isChunked() {
        return this.chunked;
    }

    public void setChunked(boolean chunked) {
        this.chunked = chunked;
    }

    public ClientResponse invoke() {
        ClientResponse clientResponse;
        block9: {
            ResteasyContext.CloseableContext ctx = this.pushProvidersContext();
            try {
                ClientRequestContextImpl requestContext = new ClientRequestContextImpl(this);
                ClientResponse aborted = this.filterRequest(requestContext);
                ClientResponse response = aborted != null ? aborted : (ClientResponse)this.client.httpEngine().invoke((Invocation)this);
                clientResponse = this.filterResponse(requestContext, response);
                if (ctx == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (ctx != null) {
                        try {
                            ctx.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ResponseProcessingException e) {
                    if (e.getResponse() != null) {
                        e.getResponse().close();
                    }
                    throw e;
                }
            }
            ctx.close();
        }
        return clientResponse;
    }

    public <T> T invoke(Class<T> responseType) {
        ClientResponse response = this.invoke();
        if (Response.class.equals(responseType)) {
            return (T)((Object)response);
        }
        return ClientInvocation.extractResult(new GenericType(responseType), (Response)response, null);
    }

    public <T> T invoke(GenericType<T> responseType) {
        ClientResponse response = this.invoke();
        if (responseType.getRawType().equals(Response.class)) {
            return (T)((Object)response);
        }
        return ClientInvocation.extractResult(responseType, (Response)response, null);
    }

    public Future<Response> submit() {
        return this.doSubmit(false, null, result -> result);
    }

    public <T> Future<T> submit(Class<T> responseType) {
        return this.doSubmit(false, null, ClientInvocation.getResponseTypeExtractor(responseType));
    }

    public <T> Future<T> submit(GenericType<T> responseType) {
        return this.doSubmit(false, null, ClientInvocation.getGenericTypeExtractor(responseType));
    }

    public <T> Future<T> submit(InvocationCallback<T> callback) {
        GenericType<Object> genericType = new GenericType<Object>(){};
        Type[] typeInfo = Types.getActualTypeArgumentsOfAnInterface(callback.getClass(), InvocationCallback.class);
        if (typeInfo != null) {
            genericType = new GenericType(typeInfo[0]);
        }
        return this.doSubmit(true, callback, ClientInvocation.getGenericTypeExtractor(genericType));
    }

    private <T> Future<T> doSubmit(boolean buffered, InvocationCallback<T> callback, AsyncClientHttpEngine.ResultExtractor<T> extractor) {
        if (this.client.httpEngine() instanceof AsyncClientHttpEngine) {
            return this.submitRequest(extractor, buffered).whenComplete((response, error) -> {
                if (callback != null) {
                    if (error != null) {
                        callback.failed(error);
                    } else {
                        try {
                            callback.completed(response);
                        }
                        catch (Throwable t) {
                            LogMessages.LOGGER.exceptionIgnored(t);
                        }
                    }
                }
            }).toCompletableFuture();
        }
        return this.executorSubmit(this.asyncInvocationExecutor(), callback, extractor);
    }

    public ExecutorService asyncInvocationExecutor() {
        return this.client.asyncInvocationExecutor();
    }

    private <T> Function<AsyncClientHttpEngine.ResultExtractor<T>, Publisher<T>> getPublisherExtractorFunction(boolean buffered) {
        ClientHttpEngine httpEngine = this.client.httpEngine();
        return httpEngine instanceof ReactiveClientHttpEngine ? ext -> ((ReactiveClientHttpEngine)httpEngine).submitRx(this, buffered, ext) : null;
    }

    protected static <T> AsyncClientHttpEngine.ResultExtractor<T> getGenericTypeExtractor(GenericType<T> responseType) {
        return response -> {
            if (responseType.getRawType().equals(Response.class)) {
                return response;
            }
            return ClientInvocation.extractResult(responseType, (Response)response, null);
        };
    }

    protected static <T> AsyncClientHttpEngine.ResultExtractor<T> getResponseTypeExtractor(Class<T> responseType) {
        return response -> {
            if (Response.class.equals((Object)responseType)) {
                return response;
            }
            return ClientInvocation.extractResult(new GenericType((Type)responseType), (Response)response, null);
        };
    }

    public CompletableFuture<Response> submitCF() {
        return this.doSubmit(response -> response, false);
    }

    public <T> CompletableFuture<T> submitCF(Class<T> responseType) {
        return this.doSubmit(ClientInvocation.getResponseTypeExtractor(responseType), true);
    }

    public <T> CompletableFuture<T> submitCF(GenericType<T> responseType) {
        return this.doSubmit(ClientInvocation.getGenericTypeExtractor(responseType), true);
    }

    private <T> CompletableFuture<T> doSubmit(AsyncClientHttpEngine.ResultExtractor<T> extractor, boolean buffered) {
        if (this.client.httpEngine() instanceof AsyncClientHttpEngine) {
            return this.submitRequest(extractor, buffered).toCompletableFuture();
        }
        return this.executorSubmit(this.asyncInvocationExecutor(), null, extractor);
    }

    public Optional<ReactiveInvocation> reactive() {
        if (this.client.httpEngine() instanceof ReactiveClientHttpEngine) {
            return Optional.of(new ReactiveInvocation((ReactiveClientHttpEngine)this.client.httpEngine()));
        }
        return Optional.empty();
    }

    public Invocation property(String name, Object value) {
        this.configuration.property(name, value);
        return this;
    }

    public ClientInvoker getClientInvoker() {
        return this.clientInvoker;
    }

    public void setClientInvoker(ClientInvoker clientInvoker) {
        this.clientInvoker = clientInvoker;
    }

    private ResteasyContext.CloseableContext pushProvidersContext() {
        ResteasyContext.CloseableContext ret = ResteasyContext.addCloseableContextDataLevel();
        ResteasyContext.pushContext(Providers.class, (Object)this.configuration);
        return ret;
    }

    protected ClientResponse filterRequest(ClientRequestContextImpl requestContext) {
        ClientRequestFilter[] requestFilters = this.getRequestFilters();
        AbortedResponse aborted = null;
        if (requestFilters != null && requestFilters.length > 0) {
            for (ClientRequestFilter filter : requestFilters) {
                try {
                    filter.filter((ClientRequestContext)requestContext);
                    if (requestContext.getAbortedWithResponse() == null) continue;
                    aborted = new AbortedResponse(this.configuration, requestContext.getAbortedWithResponse());
                    break;
                }
                catch (ProcessingException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new ProcessingException(e);
                }
            }
        }
        return aborted;
    }

    protected ClientResponse filterResponse(ClientRequestContextImpl requestContext, ClientResponse response) {
        response.setProperties(this.configuration.getMutableProperties());
        ClientResponseFilter[] responseFilters = this.getResponseFilters();
        if (responseFilters != null && responseFilters.length > 0) {
            ClientResponseContextImpl responseContext = new ClientResponseContextImpl(response);
            for (ClientResponseFilter filter : responseFilters) {
                try {
                    filter.filter((ClientRequestContext)requestContext, (ClientResponseContext)responseContext);
                }
                catch (ResponseProcessingException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new ResponseProcessingException((Response)response, e);
                }
            }
        }
        return response;
    }

    private <T> CompletionStage<T> submitRequest(AsyncClientHttpEngine.ResultExtractor<T> extractor, boolean buffered) {
        ClientRequestContextImpl requestContext = new ClientRequestContextImpl(this);
        return CompletableFuture.supplyAsync(() -> {
            try (ResteasyContext.CloseableContext ctx = this.pushProvidersContext();){
                ClientResponse aborted = this.filterRequest(requestContext);
                if (aborted != null) {
                    aborted = this.filterResponse(requestContext, aborted);
                    Object t = extractor.extractResult(aborted);
                    return t;
                }
            }
            return null;
        }, this.asyncInvocationExecutor()).thenCompose(aborted -> {
            if (aborted != null) {
                return CompletableFuture.completedFuture(aborted);
            }
            AsyncClientHttpEngine.ResultExtractor<Object> wrapped = response -> extractor.extractResult(this.filterResponse(requestContext, response));
            return ((AsyncClientHttpEngine)this.client.httpEngine()).submit(this, buffered, wrapped);
        });
    }

    private <T> CompletableFuture<T> executorSubmit(ExecutorService executor, InvocationCallback<T> callback, AsyncClientHttpEngine.ResultExtractor<T> extractor) {
        return CompletableFuture.supplyAsync(() -> {
            ClientResponse response = null;
            try {
                response = this.invoke();
                Object result = extractor.extractResult(response);
                ClientInvocation.callCompletedNoThrow(callback, result);
                Object t = result;
                return t;
            }
            catch (Exception e) {
                ClientInvocation.callFailedNoThrow(callback, e);
                throw e;
            }
            finally {
                if (response != null && callback != null) {
                    response.close();
                }
            }
        }, executor);
    }

    private static <T> void callCompletedNoThrow(InvocationCallback<T> callback, T result) {
        if (callback != null) {
            try {
                callback.completed(result);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static <T> void callFailedNoThrow(InvocationCallback<T> callback, Exception exception) {
        if (callback != null) {
            try {
                callback.failed((Throwable)exception);
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    public RESTEasyTracingLogger getTracingLogger() {
        return this.tracingLogger;
    }

    public void setActualTarget(WebTarget target) {
        this.actualTarget = target;
    }

    public WebTarget getActualTarget() {
        return this.actualTarget;
    }

    class ReactiveInvocation {
        private final ReactiveClientHttpEngine reactiveEngine;

        ReactiveInvocation(ReactiveClientHttpEngine reactiveEngine) {
            this.reactiveEngine = reactiveEngine;
        }

        public Publisher<Response> submit() {
            return this.doSubmitRx(response -> response, false);
        }

        public <T> Publisher<T> submit(Class<T> responseType) {
            return this.doSubmitRx(ClientInvocation.getResponseTypeExtractor(responseType), true);
        }

        public <T> Publisher<T> submit(GenericType<T> responseType) {
            return this.doSubmitRx(ClientInvocation.getGenericTypeExtractor(responseType), true);
        }

        private <T> Publisher<T> doSubmitRx(AsyncClientHttpEngine.ResultExtractor<T> extractor, boolean buffered) {
            return this.rxSubmit(this.reactiveEngine, ClientInvocation.this.getPublisherExtractorFunction(buffered), extractor);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private <T> Publisher<T> rxSubmit(ReactiveClientHttpEngine reactiveEngine, Function<AsyncClientHttpEngine.ResultExtractor<T>, Publisher<T>> asyncHttpEngineSubmitFn, AsyncClientHttpEngine.ResultExtractor<T> extractor) {
            ClientRequestContextImpl requestContext = new ClientRequestContextImpl(ClientInvocation.this);
            try (ResteasyContext.CloseableContext ctx = ClientInvocation.this.pushProvidersContext();){
                ClientResponse aborted = ClientInvocation.this.filterRequest(requestContext);
                if (aborted == null) return asyncHttpEngineSubmitFn.apply(response -> {
                    try (ResteasyContext.CloseableContext ctx = ClientInvocation.this.pushProvidersContext();){
                        Object t = extractor.extractResult(ClientInvocation.this.filterResponse(requestContext, response));
                        return t;
                    }
                });
                aborted = ClientInvocation.this.filterResponse(requestContext, aborted);
                T result = extractor.extractResult(aborted);
                Publisher<T> publisher = reactiveEngine.just(result);
                return publisher;
            }
            catch (Exception ex) {
                return reactiveEngine.error(ex);
            }
        }
    }
}

