/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.plugins.management.view;

import java.util.Collection;
import org.jboss.logging.Logger;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.factory.ManagedObjectFactory;
import org.jboss.managed.plugins.jmx.ManagementFactoryUtils;
import org.jboss.profileservice.plugins.management.util.ManagedDeploymentProcessor;
import org.jboss.profileservice.plugins.management.view.AbstractProfileView;
import org.jboss.profileservice.plugins.management.view.AbstractProfileViewWrapper;
import org.jboss.profileservice.plugins.spi.ProfileView;

public class PlatformMBeanView
extends AbstractProfileViewWrapper {
    private static final ManagedObjectFactory managedObjFactory = ManagedObjectFactory.getInstance();
    private static final Logger log = Logger.getLogger(PlatformMBeanView.class);
    private final AbstractProfileView view = new AbstractProfileView();

    @Override
    protected ProfileView getDelegate() {
        return this.view;
    }

    @Override
    public boolean load() {
        if (this.view.load()) {
            try {
                this.process(ManagementFactoryUtils.getPlatformMBeanMOs((ManagedObjectFactory)managedObjFactory).values());
                this.process(ManagementFactoryUtils.getGarbageCollectorMXBeans((ManagedObjectFactory)managedObjFactory));
                this.process(ManagementFactoryUtils.getMemoryManagerMXBeans((ManagedObjectFactory)managedObjFactory));
                this.process(ManagementFactoryUtils.getMemoryPoolMXBeans((ManagedObjectFactory)managedObjFactory));
            }
            catch (Exception e) {
                log.debug((Object)"failed to create platform MBean management interfaces", (Throwable)e);
            }
            return true;
        }
        return false;
    }

    protected void process(Collection<ManagedObject> managedObjects) throws Exception {
        if (managedObjects != null && !managedObjects.isEmpty()) {
            ManagedDeploymentProcessor processor = new ManagedDeploymentProcessor(this.getProxyFactory());
            for (ManagedObject mo : managedObjects) {
                processor.processManagedObject(mo, null, this.view);
            }
        }
    }

    @Override
    public void removeComponent(ManagedComponent update, ManagedComponent original) throws Exception {
    }

    @Override
    public void updateComponent(ManagedComponent update, ManagedComponent original) throws Exception {
    }
}

