/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.processor.apt;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.jboss.logging.processor.apt.AbstractMessageObjectType;
import org.jboss.logging.processor.apt.ThrowableTypeFactory;
import org.jboss.logging.processor.model.MessageMethod;
import org.jboss.logging.processor.model.Parameter;
import org.jboss.logging.processor.model.ReturnType;
import org.jboss.logging.processor.model.ThrowableType;
import org.jboss.logging.processor.util.Objects;

final class ReturnTypeFactory {
    private ReturnTypeFactory() {
    }

    public static ReturnType of(Elements elements, Types types, TypeMirror returnType, MessageMethod method) {
        if (returnType.getKind() == TypeKind.VOID) {
            return ReturnType.VOID;
        }
        AptReturnType result = new AptReturnType(elements, types, returnType, method);
        result.init();
        return result;
    }

    private static class AptReturnType
    extends AbstractMessageObjectType
    implements ReturnType {
        private final Map<String, TypeMirror> fields;
        private final Map<String, TypeMirror> methods;
        private final TypeMirror returnType;
        private final MessageMethod method;
        private ThrowableType throwableType;

        AptReturnType(Elements elements, Types types, TypeMirror returnType, MessageMethod method) {
            super(elements, types, returnType);
            this.returnType = returnType;
            this.method = method;
            this.throwableType = null;
            this.fields = new HashMap<String, TypeMirror>();
            this.methods = new HashMap<String, TypeMirror>();
        }

        @Override
        public boolean hasFieldFor(Parameter parameter) {
            return this.fields.containsKey(parameter.targetName()) && this.checkType(parameter, this.fields.get(parameter.targetName()));
        }

        @Override
        public boolean hasMethodFor(Parameter parameter) {
            return this.methods.containsKey(parameter.targetName()) && this.checkType(parameter, this.methods.get(parameter.targetName()));
        }

        @Override
        public boolean isThrowable() {
            return this.isSubtypeOf(Throwable.class);
        }

        @Override
        public boolean isPrimitive() {
            return this.returnType.getKind().isPrimitive();
        }

        @Override
        public String name() {
            return this.returnType.toString();
        }

        @Override
        public ThrowableType throwableReturnType() {
            return this.throwableType;
        }

        private void init() {
            Element e;
            if (this.isThrowable()) {
                this.throwableType = ThrowableTypeFactory.forReturnType(this.elements, this.types, this.returnType, this.method);
            }
            if ((e = this.types.asElement(this.returnType)) instanceof TypeElement) {
                List<ExecutableElement> returnTypeMethods = ElementFilter.methodsIn(this.elements.getAllMembers((TypeElement)e));
                for (ExecutableElement executableElement : returnTypeMethods) {
                    if (!executableElement.getModifiers().contains((Object)Modifier.PUBLIC) || executableElement.getParameters().size() != 1) continue;
                    this.methods.put(executableElement.getSimpleName().toString(), executableElement.getParameters().get(0).asType());
                }
                for (Element element : ElementFilter.fieldsIn(this.elements.getAllMembers((TypeElement)e))) {
                    if (!element.getModifiers().contains((Object)Modifier.PUBLIC) || element.getModifiers().contains((Object)Modifier.FINAL)) continue;
                    this.fields.put(element.getSimpleName().toString(), element.asType());
                }
            }
        }

        public int hashCode() {
            return Objects.HashCodeBuilder.builder().add(this.name()).toHashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof AptReturnType)) {
                return false;
            }
            AptReturnType other = (AptReturnType)obj;
            return Objects.areEqual(this.name(), other.name());
        }

        public String toString() {
            return Objects.ToStringBuilder.of(this).add("name", this.name()).add("primitive", this.isPrimitive()).add("throwable", this.isThrowable()).add("throwableType", this.throwableType).toString();
        }

        @Override
        public TypeMirror reference() {
            return this.returnType;
        }

        private boolean checkType(Parameter parameter, TypeMirror type) {
            if (parameter.isPrimitive()) {
                if (type.getKind().isPrimitive()) {
                    return parameter.type().equalsIgnoreCase(type.getKind().name());
                }
                return this.types.isAssignable(this.elements.getTypeElement(this.unbox(parameter)).asType(), type);
            }
            if (type.getKind().isPrimitive()) {
                TypeElement primitiveType = this.types.boxedClass((PrimitiveType)type);
                return this.types.isAssignable(this.elements.getTypeElement(parameter.type()).asType(), primitiveType.asType());
            }
            return this.types.isAssignable(this.elements.getTypeElement(parameter.type()).asType(), type);
        }

        private String unbox(Parameter parameter) {
            String result = parameter.type();
            if (parameter.isPrimitive()) {
                result = "int".equals(result) ? Integer.class.getName() : ("char".equals(result) ? Character.class.getName() : "java.lang." + Character.toUpperCase(result.charAt(0)) + result.substring(1));
            }
            return result;
        }
    }
}

