/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.webservices11.wsarj.handler;

import com.arjuna.webservices.wsarj.ArjunaConstants;
import com.arjuna.webservices11.wsarj.ArjunaContext;
import com.arjuna.webservices11.wsarj.InstanceIdentifier;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.ProtocolException;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;

public class InstanceIdentifierHandler
implements SOAPHandler<SOAPMessageContext> {
    private static Set<QName> headers = Collections.singleton(ArjunaConstants.WSARJ_ELEMENT_INSTANCE_IDENTIFIER_QNAME);

    public Set<QName> getHeaders() {
        return headers;
    }

    public boolean handleMessage(SOAPMessageContext context) throws ProtocolException {
        boolean outbound = (Boolean)context.get((Object)"javax.xml.ws.handler.message.outbound");
        if (outbound) {
            return this.handleMessageOutbound(context);
        }
        return this.handlemessageInbound(context);
    }

    protected boolean handleMessageOutbound(SOAPMessageContext context) throws ProtocolException {
        try {
            ArjunaContext arjunaContext = ArjunaContext.getCurrentContext((MessageContext)context);
            if (arjunaContext != null) {
                InstanceIdentifier instanceIdentifier = arjunaContext.getInstanceIdentifier();
                SOAPMessage soapMessage = context.getMessage();
                SOAPEnvelope soapEnvelope = soapMessage.getSOAPPart().getEnvelope();
                SOAPHeader soapHeader = soapEnvelope.getHeader();
                if (soapHeader == null) {
                    soapHeader = soapEnvelope.addHeader();
                }
                SOAPHeaderElement headerElement = soapHeader.addHeaderElement(ArjunaConstants.WSARJ_ELEMENT_INSTANCE_IDENTIFIER_QNAME);
                headerElement.setValue(instanceIdentifier.getInstanceIdentifier());
                headerElement.setMustUnderstand(true);
            }
        }
        catch (Exception se) {
            throw new ProtocolException((Throwable)se);
        }
        return true;
    }

    private boolean handlemessageInbound(SOAPMessageContext context) throws ProtocolException {
        try {
            SOAPMessage soapMessage = context.getMessage();
            SOAPEnvelope soapEnvelope = soapMessage.getSOAPPart().getEnvelope();
            Iterator iterator = soapEnvelope.getHeader().examineAllHeaderElements();
            while (iterator.hasNext()) {
                SOAPHeaderElement headerElement = (SOAPHeaderElement)iterator.next();
                if (!ArjunaConstants.WSARJ_ELEMENT_INSTANCE_IDENTIFIER_QNAME.equals(headerElement.getElementQName())) continue;
                headerElement.setMustUnderstand(false);
                String identifierString = headerElement.getValue();
                if (identifierString == null) continue;
                ArjunaContext arjunaContext = ArjunaContext.getContext((MessageContext)context);
                arjunaContext.setInstanceIdentifier(new InstanceIdentifier(identifierString));
                break;
            }
        }
        catch (Exception se) {
            throw new ProtocolException((Throwable)se);
        }
        return true;
    }

    public boolean handleFault(SOAPMessageContext context) {
        return true;
    }

    public void close(MessageContext context) {
    }
}

