/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.cache;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VFSUtils;
import org.jboss.virtual.plugins.cache.MapVFSCache;
import org.jboss.virtual.spi.ExceptionHandler;
import org.jboss.virtual.spi.VFSContext;
import org.jboss.virtual.spi.cache.CacheStatistics;
import org.jboss.virtual.spi.cache.VFSCache;
import org.jboss.virtual.spi.cache.helpers.NoopVFSCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CombinedVFSCache
implements VFSCache,
CacheStatistics {
    private PermanentVFSCache permanentCache = new PermanentVFSCache();
    private VFSCache realCache;
    private boolean initializing;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPermanentRoots(Map<URL, ExceptionHandler> initializationEntries) throws Exception {
        if (initializationEntries != null && !initializationEntries.isEmpty()) {
            if (!this.permanentCache.isStarted()) {
                this.permanentCache.start();
            }
            this.initializing = true;
            try {
                for (Map.Entry<URL, ExceptionHandler> entry : initializationEntries.entrySet()) {
                    VFS vfs = VFS.getVFS(entry.getKey());
                    ExceptionHandler eh = entry.getValue();
                    if (eh == null) continue;
                    vfs.setExceptionHandler(eh);
                }
            }
            finally {
                this.initializing = false;
            }
        }
    }

    public void setRealCache(VFSCache realCache) {
        this.realCache = realCache;
    }

    public void create() {
        this.check();
    }

    private void check() {
        if (this.realCache == null) {
            this.realCache = new NoopVFSCache();
        }
    }

    @Override
    public VFSContext findContext(URI uri) {
        VFSContext context = this.permanentCache.findContext(uri);
        if (context != null) {
            return context;
        }
        return this.realCache.findContext(uri);
    }

    @Override
    public VFSContext findContext(URL url) {
        try {
            return this.findContext(VFSUtils.toURI(url));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void putContext(VFSContext context) {
        if (this.initializing) {
            this.permanentCache.putContext(context);
        } else {
            this.check();
            this.realCache.putContext(context);
        }
    }

    @Override
    public void removeContext(VFSContext context) {
        this.check();
        this.realCache.removeContext(context);
    }

    @Override
    public void start() throws Exception {
        if (!this.permanentCache.isStarted()) {
            this.permanentCache.start();
        }
    }

    @Override
    public void stop() {
        if (this.permanentCache.isStarted()) {
            this.permanentCache.stop();
        }
    }

    @Override
    public void flush() {
        this.check();
        this.realCache.flush();
    }

    @Override
    public Iterable<VFSContext> getCachedContexts() {
        ArrayList<VFSContext> contexts = new ArrayList<VFSContext>();
        for (VFSContext context : this.permanentCache.getCachedContexts()) {
            contexts.add(context);
        }
        if (this.realCache instanceof CacheStatistics) {
            CacheStatistics cs = (CacheStatistics)CacheStatistics.class.cast(this.realCache);
            for (VFSContext context : cs.getCachedContexts()) {
                contexts.add(context);
            }
        }
        return contexts;
    }

    @Override
    public int size() {
        int size = this.permanentCache.size();
        if (this.realCache instanceof CacheStatistics) {
            size += ((CacheStatistics)CacheStatistics.class.cast(this.realCache)).size();
        }
        return size;
    }

    @Override
    public long lastInsert() {
        long permanentHit = this.permanentCache.lastInsert();
        long realHit = -1L;
        if (this.realCache instanceof CacheStatistics) {
            realHit = ((CacheStatistics)CacheStatistics.class.cast(this.realCache)).lastInsert();
        }
        return permanentHit > realHit ? permanentHit : realHit;
    }

    public String toString() {
        return "CombinedVFSCache[real-cache: " + this.realCache + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PermanentVFSCache
    extends MapVFSCache {
        private boolean started;

        private PermanentVFSCache() {
        }

        @Override
        protected Map<String, VFSContext> createMap() {
            return new TreeMap<String, VFSContext>();
        }

        @Override
        public void start() throws Exception {
            super.start();
            this.started = true;
        }

        public boolean isStarted() {
            return this.started;
        }
    }
}

