/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.platform.mbean;

import java.lang.management.ManagementFactory;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.platform.mbean.AbstractPlatformMBeanAttributeHandler;
import org.jboss.as.platform.mbean.PlatformMBeanConstants;
import org.jboss.as.platform.mbean.PlatformMBeanMessages;
import org.jboss.as.platform.mbean.PlatformMBeanUtil;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ThreadMXBeanAttributeHandler
extends AbstractPlatformMBeanAttributeHandler {
    public static ThreadMXBeanAttributeHandler INSTANCE = new ThreadMXBeanAttributeHandler();
    private final ParametersValidator enabledValidator = new ParametersValidator();

    private ThreadMXBeanAttributeHandler() {
        this.enabledValidator.registerValidator("value", (ParameterValidator)new ModelTypeValidator(ModelType.BOOLEAN));
    }

    @Override
    protected void executeReadAttribute(OperationContext context, ModelNode operation) throws OperationFailedException {
        String name = operation.require("name").asString();
        try {
            if (!(PlatformMBeanUtil.JVM_MAJOR_VERSION > 6 && "object-name".equals(name) || PlatformMBeanConstants.THREADING_READ_ATTRIBUTES.contains(name) || PlatformMBeanConstants.THREADING_READ_WRITE_ATTRIBUTES.contains(name) || PlatformMBeanConstants.THREADING_METRICS.contains(name))) {
                throw ThreadMXBeanAttributeHandler.unknownAttribute(operation);
            }
            ThreadMXBeanAttributeHandler.storeResult(name, context.getResult());
        }
        catch (SecurityException e) {
            throw new OperationFailedException(new ModelNode().set(e.toString()));
        }
        catch (UnsupportedOperationException e) {
            throw new OperationFailedException(new ModelNode().set(e.toString()));
        }
    }

    @Override
    protected void executeWriteAttribute(OperationContext context, ModelNode operation) throws OperationFailedException {
        block6: {
            String name = operation.require("name").asString();
            try {
                if ("thread-contention-monitoring-enabled".equals(name)) {
                    this.enabledValidator.validate(operation);
                    ManagementFactory.getThreadMXBean().setThreadContentionMonitoringEnabled(operation.require("value").asBoolean());
                    break block6;
                }
                if ("thread-cpu-time-enabled".equals(name)) {
                    this.enabledValidator.validate(operation);
                    ManagementFactory.getThreadMXBean().setThreadCpuTimeEnabled(operation.require("value").asBoolean());
                    break block6;
                }
                if (PlatformMBeanConstants.THREADING_READ_WRITE_ATTRIBUTES.contains(name)) {
                    throw PlatformMBeanMessages.MESSAGES.badWriteAttributeImpl4(name);
                }
                throw ThreadMXBeanAttributeHandler.unknownAttribute(operation);
            }
            catch (SecurityException e) {
                throw new OperationFailedException(new ModelNode().set(e.toString()));
            }
            catch (UnsupportedOperationException e) {
                throw new OperationFailedException(new ModelNode().set(e.toString()));
            }
        }
    }

    @Override
    protected void register(ManagementResourceRegistration registration) {
        if (PlatformMBeanUtil.JVM_MAJOR_VERSION > 6) {
            registration.registerReadOnlyAttribute("object-name", (OperationStepHandler)this, AttributeAccess.Storage.RUNTIME);
        }
        for (String attribute : PlatformMBeanConstants.THREADING_READ_WRITE_ATTRIBUTES) {
            registration.registerReadWriteAttribute(attribute, (OperationStepHandler)this, (OperationStepHandler)this, AttributeAccess.Storage.RUNTIME);
        }
        for (String attribute : PlatformMBeanConstants.THREADING_READ_ATTRIBUTES) {
            registration.registerReadOnlyAttribute(attribute, (OperationStepHandler)this, AttributeAccess.Storage.RUNTIME);
        }
        for (String attribute : PlatformMBeanConstants.THREADING_METRICS) {
            registration.registerMetric(attribute, (OperationStepHandler)this);
        }
    }

    static void storeResult(String name, ModelNode store) {
        if (PlatformMBeanUtil.JVM_MAJOR_VERSION > 6 && "object-name".equals(name)) {
            store.set("java.lang:type=Threading");
        } else if ("thread-count".equals(name)) {
            store.set(ManagementFactory.getThreadMXBean().getThreadCount());
        } else if ("peak-thread-count".equals(name)) {
            store.set(ManagementFactory.getThreadMXBean().getPeakThreadCount());
        } else if ("total-started-thread-count".equals(name)) {
            store.set(ManagementFactory.getThreadMXBean().getTotalStartedThreadCount());
        } else if ("daemon-thread-count".equals(name)) {
            store.set(ManagementFactory.getThreadMXBean().getDaemonThreadCount());
        } else if ("all-thread-ids".equals(name)) {
            store.setEmptyList();
            long[] arr$ = ManagementFactory.getThreadMXBean().getAllThreadIds();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Long id = arr$[i$];
                store.add(id.longValue());
            }
        } else if ("thread-contention-monitoring-supported".equals(name)) {
            store.set(ManagementFactory.getThreadMXBean().isThreadContentionMonitoringSupported());
        } else if ("thread-contention-monitoring-enabled".equals(name)) {
            store.set(ManagementFactory.getThreadMXBean().isThreadContentionMonitoringEnabled());
        } else if ("current-thread-cpu-time".equals(name)) {
            store.set(ManagementFactory.getThreadMXBean().getCurrentThreadCpuTime());
        } else if ("current-thread-user-time".equals(name)) {
            store.set(ManagementFactory.getThreadMXBean().getCurrentThreadUserTime());
        } else if ("thread-cpu-time-supported".equals(name)) {
            store.set(ManagementFactory.getThreadMXBean().isThreadCpuTimeSupported());
        } else if ("current-thread-cpu-time-supported".equals(name)) {
            store.set(ManagementFactory.getThreadMXBean().isCurrentThreadCpuTimeSupported());
        } else if ("thread-cpu-time-enabled".equals(name)) {
            store.set(ManagementFactory.getThreadMXBean().isThreadCpuTimeEnabled());
        } else if ("object-monitor-usage-supported".equals(name)) {
            store.set(ManagementFactory.getThreadMXBean().isObjectMonitorUsageSupported());
        } else if ("synchronizer-usage-supported".equals(name)) {
            store.set(ManagementFactory.getThreadMXBean().isSynchronizerUsageSupported());
        } else if (PlatformMBeanConstants.THREADING_READ_ATTRIBUTES.contains(name) || PlatformMBeanConstants.THREADING_READ_WRITE_ATTRIBUTES.contains(name) || PlatformMBeanConstants.THREADING_METRICS.contains(name)) {
            throw PlatformMBeanMessages.MESSAGES.badReadAttributeImpl11(name);
        }
    }
}

