/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.platform.mbean;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.platform.mbean.AbstractPlatformMBeanAttributeHandler;
import org.jboss.as.platform.mbean.PlatformMBeanConstants;
import org.jboss.as.platform.mbean.PlatformMBeanMessages;
import org.jboss.as.platform.mbean.PlatformMBeanUtil;
import org.jboss.dmr.ModelNode;

public class GarbageCollectorMXBeanAttributeHandler
extends AbstractPlatformMBeanAttributeHandler {
    public static GarbageCollectorMXBeanAttributeHandler INSTANCE = new GarbageCollectorMXBeanAttributeHandler();

    private GarbageCollectorMXBeanAttributeHandler() {
    }

    @Override
    protected void executeReadAttribute(OperationContext context, ModelNode operation) throws OperationFailedException {
        String gcName = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
        String name = operation.require("name").asString();
        GarbageCollectorMXBean gcMBean = null;
        for (GarbageCollectorMXBean mbean : ManagementFactory.getGarbageCollectorMXBeans()) {
            if (!gcName.equals(PlatformMBeanUtil.escapeMBeanName(mbean.getName()))) continue;
            gcMBean = mbean;
        }
        if (gcMBean == null) {
            throw PlatformMBeanMessages.MESSAGES.unknownGarbageCollector(gcName);
        }
        if (PlatformMBeanUtil.JVM_MAJOR_VERSION > 6 && "object-name".equals(name)) {
            String objName = PlatformMBeanUtil.getObjectNameStringWithNameKey("java.lang:type=GarbageCollector", gcName);
            context.getResult().set(objName);
        } else if ("name".equals(name)) {
            context.getResult().set(PlatformMBeanUtil.escapeMBeanName(gcMBean.getName()));
        } else if ("valid".equals(name)) {
            context.getResult().set(gcMBean.isValid());
        } else if ("memory-pool-names".equals(name)) {
            ModelNode result = context.getResult();
            result.setEmptyList();
            for (String pool : gcMBean.getMemoryPoolNames()) {
                result.add(PlatformMBeanUtil.escapeMBeanName(pool));
            }
        } else if ("collection-count".equals(name)) {
            context.getResult().set(gcMBean.getCollectionCount());
        } else if ("collection-time".equals(name)) {
            context.getResult().set(gcMBean.getCollectionTime());
        } else {
            if (PlatformMBeanConstants.GARBAGE_COLLECTOR_READ_ATTRIBUTES.contains(name) || PlatformMBeanConstants.GARBAGE_COLLECTOR_METRICS.contains(name)) {
                throw PlatformMBeanMessages.MESSAGES.badReadAttributeImpl4(name);
            }
            throw GarbageCollectorMXBeanAttributeHandler.unknownAttribute(operation);
        }
    }

    @Override
    protected void executeWriteAttribute(OperationContext context, ModelNode operation) throws OperationFailedException {
        throw GarbageCollectorMXBeanAttributeHandler.unknownAttribute(operation);
    }

    @Override
    protected void register(ManagementResourceRegistration registration) {
        if (PlatformMBeanUtil.JVM_MAJOR_VERSION > 6) {
            registration.registerReadOnlyAttribute("object-name", (OperationStepHandler)this, AttributeAccess.Storage.RUNTIME);
        }
        for (String attribute : PlatformMBeanConstants.GARBAGE_COLLECTOR_READ_ATTRIBUTES) {
            registration.registerReadOnlyAttribute(attribute, (OperationStepHandler)this, AttributeAccess.Storage.RUNTIME);
        }
        for (String attribute : PlatformMBeanConstants.GARBAGE_COLLECTOR_METRICS) {
            registration.registerMetric(attribute, (OperationStepHandler)this);
        }
    }
}

