/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.parser;

import java.util.Locale;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.osgi.parser.OSGiSubsystemProviders;
import org.jboss.as.osgi.parser.SubsystemState;
import org.jboss.dmr.ModelNode;

public class OSGiCapabilityRemove
extends AbstractRemoveStepHandler {
    static final OSGiCapabilityRemove INSTANCE = new OSGiCapabilityRemove();
    static DescriptionProvider DESCRIPTION = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ModelNode node = new ModelNode();
            node.get("operation-name").set("remove");
            node.get("description").set(OSGiSubsystemProviders.getResourceBundle(locale).getString("capability.remove"));
            node.get("request-properties").setEmptyObject();
            node.get("reply-properties").setEmptyObject();
            return node;
        }
    };

    private OSGiCapabilityRemove() {
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        String identifier = operation.get("address").asObject().get("capability").asString();
        SubsystemState subsystemState = SubsystemState.getSubsystemState(context);
        if (subsystemState != null && context.completeStep() == OperationContext.ResultAction.KEEP) {
            subsystemState.removeCapability(identifier);
        }
    }
}

