/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.config.descriptor.impl;

import org.jboss.arquillian.config.descriptor.api.EngineDef;
import org.jboss.arquillian.config.descriptor.impl.ArquillianDescriptorImpl;
import org.jboss.shrinkwrap.descriptor.api.query.Queries;
import org.jboss.shrinkwrap.descriptor.api.query.Query;
import org.jboss.shrinkwrap.descriptor.spi.Node;

public class EngineDefImpl
extends ArquillianDescriptorImpl
implements EngineDef {
    private static final Query exportPath = Queries.from((String)"property@name=deploymentExportPath");
    private static final Query maxTestClasses = Queries.from((String)"property@name=maxTestClassesBeforeRestart");
    private Node engine;

    public EngineDefImpl(String descirptorName, Node model, Node engine) {
        super(descirptorName, model);
        this.engine = engine;
    }

    public EngineDef deploymentExportPath(String path) {
        this.engine.getOrCreate(exportPath).text(path);
        return this;
    }

    public String getDeploymentExportPath() {
        return this.getTextIfExists(exportPath);
    }

    public EngineDef maxTestClassesBeforeRestart(Integer max) {
        this.engine.getOrCreate(maxTestClasses).text((Object)max);
        return this;
    }

    public Integer getMaxTestClassesBeforeRestart() {
        return this.getTextIfExistsAsInteger(maxTestClasses);
    }

    private Integer getTextIfExistsAsInteger(Query query) {
        String text = this.getTextIfExists(query);
        if (text != null) {
            return Integer.parseInt(text);
        }
        return null;
    }

    private String getTextIfExists(Query query) {
        Node propery = this.engine.getSingle(query);
        if (propery != null) {
            return propery.text();
        }
        return null;
    }
}

